/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.raft;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;

public class RaftJournalUtils {
    public static final String RAFT_DIR = "raft";

    private RaftJournalUtils() {
    }

    public static RaftPeerId getPeerId(InetSocketAddress address) {
        return RaftJournalUtils.getPeerId(address.getHostString(), address.getPort());
    }

    public static RaftPeerId getPeerId(String host, int port) {
        return RaftPeerId.getRaftPeerId((String)(host + "_" + port));
    }

    public static File getRaftJournalDir(File baseDir) {
        return new File(baseDir, RAFT_DIR);
    }

    public static File createTempSnapshotFile(SimpleStateMachineStorage storage) throws IOException {
        File tempDir = new File(storage.getSmDir().getParentFile(), "tmp");
        if (!tempDir.isDirectory() && !tempDir.mkdir()) {
            throw new IOException("Cannot create temporary snapshot directory at " + tempDir.getAbsolutePath());
        }
        return File.createTempFile("raft_snapshot_" + System.currentTimeMillis() + "_", ".dat", tempDir);
    }

    public static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }
}

