/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.raft;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journal.JournalUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.List;

public class RaftJournalConfiguration {
    private List<InetSocketAddress> mClusterAddresses;
    private long mMinElectionTimeoutMs;
    private long mMaxElectionTimeoutMs;
    private InetSocketAddress mLocalAddress;
    private long mMaxLogSize;
    private File mPath;
    private Integer mMaxConcurrencyPoolSize;

    public static RaftJournalConfiguration defaults(NetworkAddressUtils.ServiceType serviceType) {
        return new RaftJournalConfiguration().setClusterAddresses(ConfigurationUtils.getEmbeddedJournalAddresses((AlluxioConfiguration)ServerConfiguration.global(), (NetworkAddressUtils.ServiceType)serviceType)).setElectionMinTimeoutMs(ServerConfiguration.getMs(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT)).setElectionMaxTimeoutMs(ServerConfiguration.getMs(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT)).setLocalAddress(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)serviceType, (AlluxioConfiguration)ServerConfiguration.global())).setMaxLogSize(ServerConfiguration.getBytes(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX)).setPath(new File(JournalUtils.getJournalLocation().getPath())).setMaxConcurrencyPoolSize(ServerConfiguration.getInt(PropertyKey.MASTER_JOURNAL_LOG_CONCURRENCY_MAX));
    }

    public void validate() {
        Preconditions.checkState((this.getMaxLogSize() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"{} has value {} but must not exceed {}", (Object)PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, (Object)this.getMaxLogSize(), (Object)Integer.MAX_VALUE);
        Preconditions.checkState((this.getClusterAddresses().contains(this.getLocalAddress()) || NetworkAddressUtils.containsLocalIp(this.getClusterAddresses(), (AlluxioConfiguration)ServerConfiguration.global()) ? 1 : 0) != 0, (String)"The cluster addresses (%s) must contain the local master address (%s)", this.getClusterAddresses(), (Object)this.getLocalAddress());
        Preconditions.checkState((this.getMinElectionTimeoutMs() < this.getMaxElectionTimeoutMs() ? 1 : 0) != 0, (String)"min election timeout (%sms) should be less than max election timeout (%sms)", (long)this.getMinElectionTimeoutMs(), (long)this.getMaxElectionTimeoutMs());
    }

    public List<InetSocketAddress> getClusterAddresses() {
        return this.mClusterAddresses;
    }

    public long getMinElectionTimeoutMs() {
        return this.mMinElectionTimeoutMs;
    }

    public long getMaxElectionTimeoutMs() {
        return this.mMaxElectionTimeoutMs;
    }

    public InetSocketAddress getLocalAddress() {
        return this.mLocalAddress;
    }

    public InetSocketAddress getProxyAddress() {
        if (ServerConfiguration.isSet(PropertyKey.MASTER_EMBEDDED_JOURNAL_PROXY_HOST)) {
            return InetSocketAddress.createUnresolved(ServerConfiguration.get(PropertyKey.MASTER_EMBEDDED_JOURNAL_PROXY_HOST), this.getLocalAddress().getPort());
        }
        return null;
    }

    public long getMaxLogSize() {
        return this.mMaxLogSize;
    }

    public File getPath() {
        return this.mPath;
    }

    public RaftJournalConfiguration setClusterAddresses(List<InetSocketAddress> clusterAddresses) {
        this.mClusterAddresses = clusterAddresses;
        return this;
    }

    public RaftJournalConfiguration setElectionMinTimeoutMs(long minElectionTimeoutMs) {
        this.mMinElectionTimeoutMs = minElectionTimeoutMs;
        return this;
    }

    public RaftJournalConfiguration setElectionMaxTimeoutMs(long maxElectionTimeoutMs) {
        this.mMaxElectionTimeoutMs = maxElectionTimeoutMs;
        return this;
    }

    public RaftJournalConfiguration setLocalAddress(InetSocketAddress localAddress) {
        this.mLocalAddress = localAddress;
        return this;
    }

    public RaftJournalConfiguration setMaxLogSize(long maxLogSize) {
        this.mMaxLogSize = maxLogSize;
        return this;
    }

    public RaftJournalConfiguration setPath(File path) {
        this.mPath = path;
        return this;
    }

    public Integer getMaxConcurrencyPoolSize() {
        return this.mMaxConcurrencyPoolSize;
    }

    public RaftJournalConfiguration setMaxConcurrencyPoolSize(Integer maxConcurrencyPoolSize) {
        this.mMaxConcurrencyPoolSize = maxConcurrencyPoolSize;
        return this;
    }
}

