/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.raft;

import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.util.LogUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftJournalAppender
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RaftJournalAppender.class);
    private final RaftServer mServer;
    private ClientId mLocalClientId;
    private final Supplier<RaftClient> mClientSupplier;
    private volatile RaftClient mClient;
    private boolean mEnableRemoteClient;

    public RaftJournalAppender(RaftServer server, Supplier<RaftClient> clientSupplier, ClientId localClientId, InstancedConfiguration configuration) {
        this.mServer = server;
        this.mClientSupplier = clientSupplier;
        this.mLocalClientId = localClientId;
        this.mEnableRemoteClient = configuration.getBoolean(PropertyKey.MASTER_EMBEDDED_JOURNAL_WRITE_REMOTE_ENABLED);
    }

    public CompletableFuture<RaftClientReply> sendAsync(Message message, TimeDuration timeout) throws IOException {
        if (this.mEnableRemoteClient) {
            return this.sendRemoteRequest(message);
        }
        return this.sendLocalRequest(message, timeout);
    }

    private CompletableFuture<RaftClientReply> sendLocalRequest(Message message, TimeDuration timeout) throws IOException {
        LOG.trace("Sending local message {}", (Object)message);
        RaftClientRequest request = RaftClientRequest.newBuilder().setClientId(this.mLocalClientId).setServerId(this.mServer.getId()).setGroupId(RaftJournalSystem.RAFT_GROUP_ID).setCallId(RaftJournalSystem.nextCallId()).setMessage(message).setType(RaftClientRequest.writeRequestType()).setSlidingWindowEntry(null).build();
        return this.mServer.submitClientRequestAsync(request);
    }

    private CompletableFuture<RaftClientReply> sendRemoteRequest(Message message) {
        this.ensureClient();
        LOG.trace("Sending remote message {}", (Object)message);
        return this.mClient.async().send(message).exceptionally(t -> {
            this.handleRemoteException((Throwable)t);
            throw new CompletionException(t.getCause());
        });
    }

    private void ensureClient() {
        if (this.mClient == null) {
            this.mClient = this.mClientSupplier.get();
        }
    }

    private void handleRemoteException(Throwable t) {
        if (t == null) {
            return;
        }
        LOG.trace("Received remote exception", t);
        if (t instanceof AlreadyClosedException || t != null && t.getCause() instanceof AlreadyClosedException) {
            LOG.warn("Connection is closed. Closing ratis client.");
            try {
                this.mClient.close();
            }
            catch (IOException e) {
                LogUtils.warnWithException((Logger)LOG, (String)"Failed to close client: {}", (Object[])new Object[]{e.toString()});
            }
            finally {
                this.mClient = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClient != null) {
            this.mClient.close();
        }
    }
}

