/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.raft;

import alluxio.exception.status.UnavailableException;
import alluxio.master.journal.AsyncJournalWriter;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalContext;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.MasterJournalContext;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RaftJournal
implements Journal {
    private final Journaled mStateMachine;
    private final AtomicReference<AsyncJournalWriter> mJournalWriter;
    private final URI mLocation;

    public RaftJournal(Journaled stateMachine, URI location, AtomicReference<AsyncJournalWriter> journalWriter) {
        this.mStateMachine = stateMachine;
        this.mJournalWriter = journalWriter;
        this.mLocation = location;
    }

    public Journaled getStateMachine() {
        return this.mStateMachine;
    }

    @Override
    public URI getLocation() {
        return this.mLocation;
    }

    @Override
    public JournalContext createJournalContext() throws UnavailableException {
        AsyncJournalWriter journalWriter = this.mJournalWriter.get();
        if (journalWriter == null) {
            throw new UnavailableException("Journal has been closed");
        }
        return new MasterJournalContext(journalWriter);
    }

    @Override
    public void close() throws IOException {
    }
}

