/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import alluxio.util.TarUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TarballCheckpointFormat
implements CheckpointFormat {
    @Override
    public TarballCheckpointReader createReader(CheckpointInputStream in) {
        return new TarballCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        out.println("No human-readable string representation available. Use bin/alluxio readJournal to inspect the checkpoint");
    }

    public static class TarballCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final InputStream mStream;

        public TarballCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.ROCKS ? 1 : 0) != 0, (String)"Unexpected checkpoint type: %s", (Object)((Object)in.getType()));
            this.mStream = in;
        }

        public void unpackToDirectory(Path path) throws IOException {
            Files.createDirectories(path, new FileAttribute[0]);
            TarUtils.readTarGz(path, this.mStream);
        }
    }
}

