/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;

public class LongsCheckpointFormat
implements CheckpointFormat {
    @Override
    public LongsCheckpointReader createReader(CheckpointInputStream in) {
        return new LongsCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        Optional<Long> longOpt;
        LongsCheckpointReader reader = this.createReader(in);
        while ((longOpt = reader.nextLong()).isPresent()) {
            out.printf("%d%n", longOpt.get());
        }
    }

    public static class LongsCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final CheckpointInputStream mStream;

        public LongsCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.LONGS ? 1 : 0) != 0, (String)"Unexpected checkpoint type: %s", (Object)((Object)in.getType()));
            this.mStream = in;
        }

        public Optional<Long> nextLong() throws IOException {
            try {
                return Optional.of(this.mStream.readLong());
            }
            catch (EOFException e) {
                return Optional.empty();
            }
        }
    }
}

