/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;

public class LongCheckpointFormat
implements CheckpointFormat {
    @Override
    public LongCheckpointReader createReader(CheckpointInputStream in) {
        return new LongCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        LongCheckpointReader reader = this.createReader(in);
        out.println(reader.getLong());
    }

    public static class LongCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final CheckpointInputStream mStream;

        public LongCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.LONG ? 1 : 0) != 0, (String)"Unexpected checkpoint type: %s", (Object)((Object)in.getType()));
            this.mStream = in;
        }

        public Long getLong() throws IOException {
            return this.mStream.readLong();
        }
    }
}

