/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.JournalEntryStreamReader;
import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import alluxio.proto.journal.Journal;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;

public class JournalCheckpointFormat
implements CheckpointFormat {
    private static final String ENTRY_SEPARATOR = Strings.repeat((String)"-", (int)80);

    @Override
    public JournalCheckpointReader createReader(CheckpointInputStream in) {
        return new JournalCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        Optional<Journal.JournalEntry> entry;
        JournalCheckpointReader reader = this.createReader(in);
        while ((entry = reader.nextEntry()).isPresent()) {
            out.println(ENTRY_SEPARATOR);
            out.println(entry.get());
        }
    }

    public static class JournalCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final JournalEntryStreamReader mReader;

        public JournalCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.JOURNAL_ENTRY ? 1 : 0) != 0, (Object)("Unexpected checkpoint type: " + (Object)((Object)in.getType())));
            this.mReader = new JournalEntryStreamReader(in);
        }

        public Optional<Journal.JournalEntry> nextEntry() throws IOException {
            return Optional.ofNullable(this.mReader.readEntry());
        }
    }
}

