/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import alluxio.proto.meta.InodeMeta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Optional;

public class InodeProtosCheckpointFormat
implements CheckpointFormat {
    private static final String ENTRY_SEPARATOR = Strings.repeat((String)"-", (int)80);

    @Override
    public InodeProtosCheckpointReader createReader(CheckpointInputStream in) {
        return new InodeProtosCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        Optional<InodeMeta.Inode> entry;
        InodeProtosCheckpointReader reader = this.createReader(in);
        while ((entry = reader.read()).isPresent()) {
            out.println(ENTRY_SEPARATOR);
            out.println(entry.get());
        }
    }

    private static class InodeProtosCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final InputStream mStream;

        public InodeProtosCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.INODE_PROTOS ? 1 : 0) != 0);
            this.mStream = in;
        }

        public Optional<InodeMeta.Inode> read() throws IOException {
            return Optional.ofNullable(InodeMeta.Inode.parseDelimitedFrom((InputStream)this.mStream));
        }
    }
}

