/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.master.journal.PatchedInputChunked;
import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointName;
import alluxio.master.journal.checkpoint.CheckpointType;
import com.esotericsoftware.kryo.io.InputChunked;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Optional;

public class CompoundCheckpointFormat
implements CheckpointFormat {
    @Override
    public CompoundCheckpointReader createReader(CheckpointInputStream in) {
        return new CompoundCheckpointReader(in);
    }

    @Override
    public void parseToHumanReadable(CheckpointInputStream in, PrintStream out) throws IOException {
        Optional<CompoundCheckpointReader.Entry> entryOpt;
        CompoundCheckpointReader reader = this.createReader(in);
        while ((entryOpt = reader.nextCheckpoint()).isPresent()) {
            CompoundCheckpointReader.Entry entry = entryOpt.get();
            out.printf("--- Begin checkpoint for %s ---%n", new Object[]{entry.getName()});
            CheckpointFormat format = entry.getStream().getType().getCheckpointFormat();
            format.parseToHumanReadable(entry.getStream(), out);
            out.printf("--- End checkpoint for %s ---%n", new Object[]{entry.getName()});
        }
    }

    public static class CompoundCheckpointReader
    implements CheckpointFormat.CheckpointReader {
        private final InputChunked mStream;
        private boolean mFirstCheckpoint = true;

        public CompoundCheckpointReader(CheckpointInputStream in) {
            Preconditions.checkState((in.getType() == CheckpointType.COMPOUND ? 1 : 0) != 0, (String)"Unexpected checkpoint type: %s", (Object)((Object)in.getType()));
            this.mStream = new PatchedInputChunked(in);
        }

        public Optional<Entry> nextCheckpoint() throws IOException {
            if (this.mFirstCheckpoint) {
                this.mFirstCheckpoint = false;
            } else {
                this.mStream.nextChunks();
            }
            if (this.mStream.eof()) {
                return Optional.empty();
            }
            CheckpointName name = CheckpointName.valueOf(this.mStream.readString());
            CheckpointInputStream cis = new CheckpointInputStream((InputStream)this.mStream);
            return Optional.of(new Entry(name, cis));
        }

        public static class Entry {
            private final CheckpointName mName;
            private final CheckpointInputStream mStream;

            public Entry(CheckpointName name, CheckpointInputStream stream) {
                this.mName = name;
                this.mStream = stream;
            }

            public CheckpointName getName() {
                return this.mName;
            }

            public CheckpointInputStream getStream() {
                return this.mStream;
            }
        }
    }
}

