/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.RuntimeConstants;
import alluxio.master.journal.checkpoint.CheckpointFormat;
import alluxio.master.journal.checkpoint.CompoundCheckpointFormat;
import alluxio.master.journal.checkpoint.InodeProtosCheckpointFormat;
import alluxio.master.journal.checkpoint.JournalCheckpointFormat;
import alluxio.master.journal.checkpoint.LongCheckpointFormat;
import alluxio.master.journal.checkpoint.LongsCheckpointFormat;
import alluxio.master.journal.checkpoint.TarballCheckpointFormat;

public enum CheckpointType {
    JOURNAL_ENTRY(0L, new JournalCheckpointFormat()),
    COMPOUND(1L, new CompoundCheckpointFormat()),
    LONGS(2L, new LongsCheckpointFormat()),
    ROCKS(3L, new TarballCheckpointFormat()),
    INODE_PROTOS(4L, new InodeProtosCheckpointFormat()),
    LONG(5L, new LongCheckpointFormat());

    private final long mId;
    private final CheckpointFormat mCheckpointFormat;

    private CheckpointType(long id, CheckpointFormat checkpointFormat) {
        this.mId = id;
        this.mCheckpointFormat = checkpointFormat;
    }

    public long getId() {
        return this.mId;
    }

    public CheckpointFormat getCheckpointFormat() {
        return this.mCheckpointFormat;
    }

    public static CheckpointType fromLong(long id) {
        for (CheckpointType type : CheckpointType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        throw new IllegalStateException(String.format("Unknown checkpoint type id: %d. Was your checkpoint written by alluxio-1.x? See %s for instructions on how to upgrade from alluxio-1.x to alluxio-2.x", id, RuntimeConstants.ALLUXIO_2X_UPGRADE_DOC_URL));
    }
}

