/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal.checkpoint;

import alluxio.RuntimeConstants;
import alluxio.master.journal.checkpoint.CheckpointType;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckpointInputStream
extends DataInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointInputStream.class);
    private final CheckpointType mType;

    public CheckpointInputStream(InputStream in) throws IOException {
        super(in);
        long id;
        try {
            id = this.readLong();
        }
        catch (EOFException e) {
            LOG.error("Failed to read checkpoint type.", (Throwable)e);
            throw new IllegalStateException(String.format("EOF while parsing checkpoint type. Was your checkpoint written by alluxio-1.x? See %s for instructions on how to upgrade from alluxio-1.x to alluxio-2.x", RuntimeConstants.ALLUXIO_2X_UPGRADE_DOC_URL), e);
        }
        this.mType = CheckpointType.fromLong(id);
    }

    public CheckpointType getType() {
        return this.mType;
    }
}

