/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.exception.status.UnavailableException;
import alluxio.master.journal.JournalContext;
import alluxio.proto.journal.Journal;
import alluxio.resource.LockResource;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class StateChangeJournalContext
implements JournalContext {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangeJournalContext.class);
    private final JournalContext mJournalContext;
    private final LockResource mStateLockResource;

    public StateChangeJournalContext(JournalContext journalContext, LockResource stateLockResource) {
        Preconditions.checkNotNull((Object)journalContext, (Object)"journalContext");
        this.mJournalContext = journalContext;
        this.mStateLockResource = stateLockResource;
    }

    @Override
    public void append(Journal.JournalEntry entry) {
        this.mJournalContext.append(entry);
    }

    @Override
    public void close() throws UnavailableException {
        try {
            this.mJournalContext.close();
        }
        finally {
            this.mStateLockResource.close();
        }
    }
}

