/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.AlluxioURI;
import alluxio.exception.status.UnavailableException;
import alluxio.master.journal.JournalContext;
import alluxio.proto.journal.Journal;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MergeJournalContext
implements JournalContext {
    public static final int MAX_ENTRIES = 100;
    private static final long INVALID_FILE_ID = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(MergeJournalContext.class);
    private final JournalContext mJournalContext;
    private final AlluxioURI mUri;
    private final UnaryOperator<List<Journal.JournalEntry>> mMergeOperator;
    private final List<Journal.JournalEntry> mJournalEntries;
    private long mFileId = -1L;

    public MergeJournalContext(JournalContext journalContext, AlluxioURI uri, UnaryOperator<List<Journal.JournalEntry>> merger) {
        Preconditions.checkNotNull((Object)journalContext, (Object)"journalContext");
        this.mJournalContext = journalContext;
        this.mMergeOperator = merger;
        this.mJournalEntries = new ArrayList<Journal.JournalEntry>();
        this.mUri = uri;
    }

    @Override
    public void append(Journal.JournalEntry entry) {
        boolean merge = false;
        if (entry.hasInodeFile() || entry.hasUpdateInode() || entry.hasUpdateInodeFile()) {
            if (entry.hasInodeFile() && entry.getInodeFile().getPath().equals(this.mUri.getPath())) {
                merge = true;
                this.mFileId = entry.getInodeFile().getId();
            } else if (entry.hasUpdateInodeFile() && this.mFileId != -1L && entry.getUpdateInodeFile().getId() == this.mFileId) {
                merge = true;
            } else if (entry.hasUpdateInode() && this.mFileId != -1L && entry.getUpdateInode().getId() == this.mFileId) {
                merge = true;
            }
        }
        if (merge) {
            this.mJournalEntries.add(entry);
        } else {
            this.mJournalContext.append(entry);
        }
    }

    @Override
    public void close() throws UnavailableException {
        if (this.mJournalEntries.size() > 100) {
            LOG.debug("MergeJournalContext has " + this.mJournalEntries.size() + " entries, over the limit of " + 100);
        }
        List mergedEntries = (List)this.mMergeOperator.apply(this.mJournalEntries);
        mergedEntries.forEach(this.mJournalContext::append);
    }
}

