/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.ProcessUtils;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.JournalClosedException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.journal.AsyncJournalWriter;
import alluxio.master.journal.JournalContext;
import alluxio.proto.journal.Journal;
import alluxio.retry.TimeoutRetry;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MasterJournalContext
implements JournalContext {
    private static final Logger LOG = LoggerFactory.getLogger(MasterJournalContext.class);
    private static final long INVALID_FLUSH_COUNTER = -1L;
    private static final long FLUSH_RETRY_TIMEOUT_MS = ServerConfiguration.getMs(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS);
    private static final int FLUSH_RETRY_INTERVAL_MS = (int)ServerConfiguration.getMs(PropertyKey.MASTER_JOURNAL_FLUSH_RETRY_INTERVAL);
    private final AsyncJournalWriter mAsyncJournalWriter;
    private long mFlushCounter;

    public MasterJournalContext(AsyncJournalWriter asyncJournalWriter) {
        Preconditions.checkNotNull((Object)asyncJournalWriter, (Object)"asyncJournalWriter");
        this.mAsyncJournalWriter = asyncJournalWriter;
        this.mFlushCounter = -1L;
    }

    @Override
    public void append(Journal.JournalEntry entry) {
        this.mFlushCounter = this.mAsyncJournalWriter.appendEntry(entry);
    }

    private void waitForJournalFlush() throws UnavailableException {
        if (this.mFlushCounter == -1L) {
            return;
        }
        TimeoutRetry retry = new TimeoutRetry(FLUSH_RETRY_TIMEOUT_MS, FLUSH_RETRY_INTERVAL_MS);
        while (retry.attempt()) {
            try {
                this.mAsyncJournalWriter.flush(this.mFlushCounter);
                return;
            }
            catch (JournalClosedException | NotLeaderException e) {
                throw new UnavailableException(String.format("Failed to complete request: %s", e.getMessage()), e);
            }
            catch (AlluxioStatusException e) {
                if (e.getStatus().equals((Object)Status.CANCELLED)) {
                    LOG.warn("Journal flush interrupted because the RPC was cancelled. ", (Throwable)e);
                    continue;
                }
                LOG.warn("Journal flush failed. retrying...", (Throwable)e);
            }
            catch (IOException e) {
                if (e instanceof AlluxioStatusException && ((AlluxioStatusException)((Object)e)).getStatusCode() == Status.Code.CANCELLED) {
                    throw new UnavailableException(String.format("Failed to complete request: %s", e.getMessage()), (Throwable)e);
                }
                LOG.warn("Journal flush failed. retrying...", (Throwable)e);
            }
            catch (Throwable e) {
                ProcessUtils.fatalError(LOG, e, "Journal flush failed", new Object[0]);
            }
        }
        ProcessUtils.fatalError(LOG, "Journal flush failed after %d attempts", retry.getAttemptCount());
    }

    @Override
    public void close() throws UnavailableException {
        this.waitForJournalFlush();
    }
}

