/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.master.journal.JournalEntryIterable;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointName;
import alluxio.proto.journal.Journal;
import alluxio.resource.CloseableIterator;
import alluxio.util.StreamUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class JournaledGroup
implements Journaled {
    private final List<Journaled> mJournaled;
    private final CheckpointName mCheckpointName;

    public JournaledGroup(List<Journaled> journaled, CheckpointName checkpointName) {
        this.mJournaled = journaled;
        this.mCheckpointName = checkpointName;
    }

    public List<Journaled> getJournaled() {
        return this.mJournaled;
    }

    @Override
    public boolean processJournalEntry(Journal.JournalEntry entry) {
        for (Journaled journaled : this.mJournaled) {
            if (!journaled.processJournalEntry(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetState() {
        Lists.reverse(this.mJournaled).forEach(Journaled::resetState);
    }

    @Override
    public CheckpointName getCheckpointName() {
        return this.mCheckpointName;
    }

    @Override
    public void writeToCheckpoint(OutputStream output) throws IOException, InterruptedException {
        JournalUtils.writeToCheckpoint(output, this.mJournaled);
    }

    @Override
    public void restoreFromCheckpoint(CheckpointInputStream input) throws IOException {
        JournalUtils.restoreFromCheckpoint(input, this.mJournaled);
    }

    @Override
    public CloseableIterator<Journal.JournalEntry> getJournalEntryIterator() {
        List componentIters = StreamUtils.map(JournalEntryIterable::getJournalEntryIterator, this.mJournaled);
        return CloseableIterator.concat((List)componentIters);
    }
}

