/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.master.journal.JournalContext;
import alluxio.master.journal.JournalEntryIterable;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.Checkpointed;
import alluxio.proto.journal.Journal;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;

public interface Journaled
extends Checkpointed,
JournalEntryIterable {
    public boolean processJournalEntry(Journal.JournalEntry var1);

    public void resetState();

    default public void applyAndJournal(Supplier<JournalContext> context, Journal.JournalEntry entry) {
        this.processJournalEntry(entry);
        context.get().append(entry);
    }

    @Override
    default public void writeToCheckpoint(OutputStream output) throws IOException, InterruptedException {
        JournalUtils.writeJournalEntryCheckpoint(output, this);
    }

    @Override
    default public void restoreFromCheckpoint(CheckpointInputStream input) throws IOException {
        JournalUtils.restoreJournalEntryCheckpoint(input, this);
    }
}

