/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.journal.JournalEntryIterable;
import alluxio.master.journal.JournalEntryStreamReader;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.checkpoint.CheckpointInputStream;
import alluxio.master.journal.checkpoint.CheckpointOutputStream;
import alluxio.master.journal.checkpoint.CheckpointType;
import alluxio.master.journal.checkpoint.Checkpointed;
import alluxio.master.journal.checkpoint.CompoundCheckpointFormat;
import alluxio.master.journal.sink.JournalSink;
import alluxio.proto.journal.Journal;
import alluxio.resource.CloseableIterator;
import alluxio.util.StreamUtils;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JournalUtils.class);

    public static URI getJournalLocation() {
        String journalDirectory = ServerConfiguration.get(PropertyKey.MASTER_JOURNAL_FOLDER);
        if (!journalDirectory.endsWith("/")) {
            journalDirectory = journalDirectory + "/";
        }
        try {
            return new URI(journalDirectory);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJournalEntryCheckpoint(OutputStream output, JournalEntryIterable iterable) throws IOException, InterruptedException {
        output = new CheckpointOutputStream(output, CheckpointType.JOURNAL_ENTRY);
        try (CloseableIterator<Journal.JournalEntry> it = iterable.getJournalEntryIterator();){
            LOG.info("Write journal entry checkpoint");
            while (((Iterator)it.get()).hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ((Journal.JournalEntry)((Iterator)it.get()).next()).writeDelimitedTo(output);
            }
        }
        output.flush();
    }

    public static void restoreJournalEntryCheckpoint(CheckpointInputStream input, Journaled journaled) throws IOException {
        Journal.JournalEntry entry;
        Preconditions.checkState((input.getType() == CheckpointType.JOURNAL_ENTRY ? 1 : 0) != 0, (String)"Unrecognized checkpoint type when restoring %s: %s", (Object)((Object)journaled.getCheckpointName()), (Object)((Object)input.getType()));
        journaled.resetState();
        LOG.info("Reading journal entries");
        JournalEntryStreamReader reader = new JournalEntryStreamReader(input);
        while ((entry = reader.readEntry()) != null) {
            try {
                journaled.processJournalEntry(entry);
            }
            catch (Throwable t) {
                JournalUtils.handleJournalReplayFailure(LOG, t, "Failed to process journal entry %s from a journal checkpoint", entry);
            }
        }
    }

    public static void writeToCheckpoint(OutputStream output, List<? extends Checkpointed> components) throws IOException, InterruptedException {
        OutputChunked chunked = new OutputChunked((OutputStream)new CheckpointOutputStream(output, CheckpointType.COMPOUND), 65536);
        for (Checkpointed checkpointed : components) {
            chunked.writeString(checkpointed.getCheckpointName().toString());
            checkpointed.writeToCheckpoint((OutputStream)chunked);
            chunked.endChunks();
        }
        chunked.flush();
    }

    public static void restoreFromCheckpoint(CheckpointInputStream input, List<? extends Checkpointed> components) throws IOException {
        Optional<CompoundCheckpointFormat.CompoundCheckpointReader.Entry> next;
        CompoundCheckpointFormat.CompoundCheckpointReader reader = new CompoundCheckpointFormat.CompoundCheckpointReader(input);
        while ((next = reader.nextCheckpoint()).isPresent()) {
            CompoundCheckpointFormat.CompoundCheckpointReader.Entry nextEntry = next.get();
            boolean found = false;
            for (Checkpointed checkpointed : components) {
                if (!checkpointed.getCheckpointName().equals((Object)nextEntry.getName())) continue;
                checkpointed.restoreFromCheckpoint(nextEntry.getStream());
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException(String.format("Unrecognized checkpoint name: %s. Existing components: %s", new Object[]{nextEntry.getName(), Arrays.toString(StreamUtils.map(Checkpointed::getCheckpointName, components).toArray())}));
        }
    }

    public static void handleJournalReplayFailure(Logger logger, Throwable t, String format, Object ... args) throws RuntimeException {
        String message = String.format("Journal replay error: " + format, args);
        if (t != null) {
            message = message + "\n" + Throwables.getStackTraceAsString((Throwable)t);
        }
        if (ServerConfiguration.getBoolean(PropertyKey.TEST_MODE)) {
            throw new RuntimeException(message);
        }
        logger.error(message);
        if (!ServerConfiguration.getBoolean(PropertyKey.MASTER_JOURNAL_TOLERATE_CORRUPTION)) {
            System.exit(-1);
            throw new RuntimeException(t);
        }
    }

    public static void sinkAppend(Supplier<Set<JournalSink>> journalSinks, Journal.JournalEntry entry) {
        for (JournalSink sink : journalSinks.get()) {
            sink.append(entry);
        }
    }

    public static void sinkFlush(Supplier<Set<JournalSink>> journalSinks) {
        for (JournalSink sink : journalSinks.get()) {
            sink.flush();
        }
    }

    private JournalUtils() {
    }
}

