/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.MasterFactory;
import alluxio.master.NoopMaster;
import alluxio.master.ServiceUtils;
import alluxio.master.journal.JournalFileParser;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journalv0.JournalWriter;
import alluxio.master.journalv0.MutableJournal;
import alluxio.proto.journal.Journal;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.util.ConfigurationUtils;
import alluxio.util.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JournalUpgrader {
    private static final Logger LOG = LoggerFactory.getLogger(JournalUpgrader.class);
    private static final int EXIT_FAILED = -1;
    private static final int EXIT_SUCCEEDED = 0;
    private static final Options OPTIONS = new Options().addOption("help", false, "Show help for this test.").addOption("journalDirectoryV0", true, "Where the v0 journal is persisted. It is assumed to be the same as the v1 journal directory if not set.");
    private static boolean sHelp;
    private static String sJournalDirectoryV0;

    private JournalUpgrader() {
    }

    public static void main(String[] args) {
        if (!JournalUpgrader.parseInputArgs(args)) {
            JournalUpgrader.usage();
            System.exit(-1);
        }
        if (sHelp) {
            JournalUpgrader.usage();
            System.exit(0);
        }
        ArrayList<String> masters = new ArrayList<String>();
        for (MasterFactory factory : ServiceUtils.getMasterServiceLoader()) {
            masters.add(factory.getName());
        }
        for (String master : masters) {
            Upgrader upgrader = new Upgrader(master, (AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
            try {
                upgrader.upgrade();
            }
            catch (IOException e) {
                LOG.error("Failed to upgrade the journal for {}.", (Object)master, (Object)e);
                System.exit(-1);
            }
        }
    }

    private static boolean parseInputArgs(String[] args) {
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.out.println("Failed to parse input args: " + (Object)((Object)e));
            return false;
        }
        sHelp = cmd.hasOption("help");
        sJournalDirectoryV0 = cmd.getOptionValue("journalDirectoryV0", ServerConfiguration.get(PropertyKey.MASTER_JOURNAL_FOLDER));
        return true;
    }

    private static void usage() {
        new HelpFormatter().printHelp("java -cp alluxio-2.7.3-jar-with-dependencies.jar alluxio.master.journal.JournalUpgrader", "Upgrades journal from v0 to v1", OPTIONS, "", true);
    }

    private static final class Upgrader {
        private final String mMaster;
        private final MutableJournal mJournalV0;
        private final UfsJournal mJournalV1;
        private final UnderFileSystem mUfs;
        private final URI mCheckpointV0;
        private final URI mCompletedLogsV0;
        private final URI mCheckpointsV1;
        private final URI mLogsV1;
        private final AlluxioConfiguration mAlluxioConf;

        private Upgrader(String master, AlluxioConfiguration alluxioConf) {
            this.mMaster = master;
            this.mAlluxioConf = alluxioConf;
            this.mJournalV0 = new MutableJournal.Factory(this.getJournalLocation(sJournalDirectoryV0)).create(master);
            this.mJournalV1 = new UfsJournal(this.getJournalLocation(ServerConfiguration.get(PropertyKey.MASTER_JOURNAL_FOLDER)), new NoopMaster(master), 0L, Collections::emptySet);
            this.mUfs = UnderFileSystem.Factory.create((String)sJournalDirectoryV0, (UnderFileSystemConfiguration)UnderFileSystemConfiguration.defaults((AlluxioConfiguration)alluxioConf));
            this.mCheckpointV0 = URIUtils.appendPathOrDie((URI)this.mJournalV0.getLocation(), (String)"checkpoint.data");
            this.mCompletedLogsV0 = URIUtils.appendPathOrDie((URI)this.mJournalV0.getLocation(), (String)"completed");
            this.mCheckpointsV1 = URIUtils.appendPathOrDie((URI)this.mJournalV1.getLocation(), (String)"checkpoints");
            this.mLogsV1 = URIUtils.appendPathOrDie((URI)this.mJournalV1.getLocation(), (String)"logs");
        }

        void upgrade() throws IOException {
            URI completedLog;
            if (!this.mUfs.exists(this.mCheckpointV0.toString())) {
                LOG.info("No checkpoint is found for {}. No upgrade is required.", (Object)this.mMaster);
                return;
            }
            this.prepare();
            LOG.info("Starting to upgrade {} journal.", (Object)this.mMaster);
            boolean checkpointUpgraded = false;
            int logNumber = 1;
            while (this.mUfs.exists((completedLog = this.getCompletedLogV0(logNumber)).toString())) {
                long start = -1L;
                long end = -1L;
                ++logNumber;
                try (JournalFileParser parser = JournalFileParser.Factory.create(completedLog);){
                    Journal.JournalEntry entry;
                    while ((entry = parser.next()) != null) {
                        if (start == -1L) {
                            start = entry.getSequenceNumber();
                        }
                        end = entry.getSequenceNumber();
                    }
                }
                if (!checkpointUpgraded) {
                    this.renameCheckpoint(start);
                    checkpointUpgraded = true;
                }
                URI dst = URIUtils.appendPathOrDie((URI)this.mLogsV1, (String)String.format("0x%x-0x%x", start, end + 1L));
                if (this.mUfs.renameFile(completedLog.toString(), dst.toString()) || this.mUfs.exists(dst.toString())) continue;
                throw new IOException(String.format("Failed to rename %s to %s.", completedLog.toString(), dst.toString()));
            }
            if (!checkpointUpgraded) {
                this.renameCheckpoint(1L);
            }
            LOG.info("Finished upgrading {} journal.", (Object)this.mMaster);
        }

        private void prepare() throws IOException {
            JournalWriter journalWriterV0 = this.mJournalV0.getWriter();
            journalWriterV0.recover();
            journalWriterV0.completeLogs();
            journalWriterV0.close();
            if (!this.mJournalV1.isFormatted()) {
                LOG.info("Starting to format journal {}.", (Object)this.mJournalV1.getLocation());
                this.mJournalV1.format();
                LOG.info("Finished formatting journal {}.", (Object)this.mJournalV1.getLocation());
            }
            if (!this.mUfs.exists(this.mCheckpointsV1.toString())) {
                this.mUfs.mkdirs(this.mCheckpointsV1.toString(), MkdirsOptions.defaults((AlluxioConfiguration)this.mAlluxioConf).setCreateParent(true));
            }
            if (!this.mUfs.exists(this.mLogsV1.toString())) {
                this.mUfs.mkdirs(this.mLogsV1.toString(), MkdirsOptions.defaults((AlluxioConfiguration)this.mAlluxioConf).setCreateParent(true));
            }
        }

        private void renameCheckpoint(long sequenceNumber) throws IOException {
            URI dst = URIUtils.appendPathOrDie((URI)this.mCheckpointsV1, (String)String.format("0x0-0x%x", sequenceNumber));
            if (!this.mUfs.renameFile(this.mCheckpointV0.toString(), dst.toString()) && !this.mUfs.exists(dst.toString())) {
                throw new IOException(String.format("Failed to rename %s to %s.", this.mCheckpointV0.toString(), dst.toString()));
            }
        }

        private URI getCompletedLogV0(long logNumber) {
            return URIUtils.appendPathOrDie((URI)this.mCompletedLogsV0, (String)String.format("%s.%020d", "log", logNumber));
        }

        private URI getJournalLocation(String journalDirectory) {
            if (!journalDirectory.endsWith("/")) {
                journalDirectory = journalDirectory + "/";
            }
            try {
                return new URI(journalDirectory);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

