/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.master.Master;
import alluxio.master.journal.CatchupFuture;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalType;
import alluxio.master.journal.noop.NoopJournalSystem;
import alluxio.master.journal.raft.RaftJournalConfiguration;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.master.journal.sink.JournalSink;
import alluxio.master.journal.ufs.UfsJournalSystem;
import alluxio.util.CommonUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface JournalSystem {
    public Journal createJournal(Master var1);

    public void start() throws InterruptedException, IOException;

    public void stop() throws InterruptedException, IOException;

    public void gainPrimacy();

    public void losePrimacy();

    public void suspend(Runnable var1) throws IOException;

    public void resume() throws IOException;

    public CatchupFuture catchup(Map<String, Long> var1) throws IOException;

    default public void waitForCatchup() {
    }

    public Map<String, Long> getCurrentSequenceNumbers();

    public void format() throws IOException;

    public boolean isFormatted() throws IOException;

    public void addJournalSink(Master var1, JournalSink var2);

    public void removeJournalSink(Master var1, JournalSink var2);

    public Set<JournalSink> getJournalSinks(@Nullable Master var1);

    public boolean isEmpty();

    public void checkpoint() throws IOException;

    default public Map<ServiceType, GrpcService> getJournalServices() {
        return Collections.EMPTY_MAP;
    }

    public static class Builder {
        private URI mLocation;
        private long mQuietTimeMs = ServerConfiguration.getMs(PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS);

        public Builder setLocation(URI location) {
            this.mLocation = location;
            return this;
        }

        public Builder setQuietTimeMs(long quietTimeMs) {
            this.mQuietTimeMs = quietTimeMs;
            return this;
        }

        public JournalSystem build(CommonUtils.ProcessType processType) {
            JournalType journalType = ServerConfiguration.getEnum(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.class);
            switch (journalType) {
                case NOOP: {
                    return new NoopJournalSystem();
                }
                case UFS: {
                    return new UfsJournalSystem(this.mLocation, this.mQuietTimeMs);
                }
                case EMBEDDED: {
                    NetworkAddressUtils.ServiceType serviceType = processType.equals((Object)CommonUtils.ProcessType.MASTER) ? NetworkAddressUtils.ServiceType.MASTER_RAFT : NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT;
                    return RaftJournalSystem.create(RaftJournalConfiguration.defaults(serviceType).setPath(new File(this.mLocation.getPath())));
                }
            }
            throw new IllegalStateException("Unrecognized journal type: " + (Object)((Object)journalType));
        }
    }

    public static enum Mode {
        PRIMARY,
        STANDBY;

    }
}

