/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.RpcUtils;
import alluxio.grpc.GetQuorumInfoPRequest;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.GetTransferLeaderMessagePRequest;
import alluxio.grpc.GetTransferLeaderMessagePResponse;
import alluxio.grpc.JournalMasterClientServiceGrpc;
import alluxio.grpc.RemoveQuorumServerPRequest;
import alluxio.grpc.RemoveQuorumServerPResponse;
import alluxio.grpc.ResetPrioritiesPRequest;
import alluxio.grpc.ResetPrioritiesPResponse;
import alluxio.grpc.TransferLeadershipPRequest;
import alluxio.grpc.TransferLeadershipPResponse;
import alluxio.master.journal.JournalMaster;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalMasterClientServiceHandler
extends JournalMasterClientServiceGrpc.JournalMasterClientServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(JournalMasterClientServiceHandler.class);
    private JournalMaster mJournalMaster;

    public JournalMasterClientServiceHandler(JournalMaster journalMaster) {
        this.mJournalMaster = journalMaster;
    }

    public void getQuorumInfo(GetQuorumInfoPRequest request, StreamObserver<GetQuorumInfoPResponse> responseObserver) {
        RpcUtils.call(LOG, () -> this.mJournalMaster.getQuorumInfo(), "getQuorumInfo", "request=%s", responseObserver, request);
    }

    public void removeQuorumServer(RemoveQuorumServerPRequest request, StreamObserver<RemoveQuorumServerPResponse> responseObserver) {
        RpcUtils.call(LOG, () -> {
            this.mJournalMaster.removeQuorumServer(request.getServerAddress());
            return RemoveQuorumServerPResponse.getDefaultInstance();
        }, "removeQuorumServer", "request=%s", responseObserver, request);
    }

    public void transferLeadership(TransferLeadershipPRequest request, StreamObserver<TransferLeadershipPResponse> responseObserver) {
        RpcUtils.call(LOG, () -> {
            String transferId = this.mJournalMaster.transferLeadership(request.getServerAddress());
            return TransferLeadershipPResponse.newBuilder().setTransferId(transferId).build();
        }, "transferLeadership", "request=%s", responseObserver, request);
    }

    public void resetPriorities(ResetPrioritiesPRequest request, StreamObserver<ResetPrioritiesPResponse> responseObserver) {
        RpcUtils.call(LOG, () -> {
            this.mJournalMaster.resetPriorities();
            return ResetPrioritiesPResponse.getDefaultInstance();
        }, "resetPriorities", "request=%s", responseObserver, request);
    }

    public void getTransferLeaderMessage(GetTransferLeaderMessagePRequest request, StreamObserver<GetTransferLeaderMessagePResponse> responseObserver) {
        RpcUtils.call(LOG, () -> this.mJournalMaster.getTransferLeaderMessage(request.getTransferId()), "GetTransferLeaderMessage", "request=%s", responseObserver, request);
    }
}

