/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.proto.journal.Journal;
import alluxio.util.proto.ProtoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalEntryStreamReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JournalEntryStreamReader.class);
    private final InputStream mStream;
    private byte[] mBuffer = new byte[4096];

    public JournalEntryStreamReader(InputStream stream) {
        this.mStream = stream;
    }

    public Journal.JournalEntry readEntry() throws IOException {
        int totalBytesRead;
        int latestBytesRead;
        int size;
        int firstByte = this.mStream.read();
        if (firstByte == -1) {
            return null;
        }
        try {
            size = ProtoUtils.readRawVarint32((int)firstByte, (InputStream)this.mStream);
        }
        catch (IOException e) {
            LOG.warn("Journal entry was truncated in the size portion.");
            throw e;
        }
        if (this.mBuffer.length < size) {
            this.mBuffer = new byte[size];
        }
        for (totalBytesRead = 0; totalBytesRead < size && (latestBytesRead = this.mStream.read(this.mBuffer, totalBytesRead, size - totalBytesRead)) >= 0; totalBytesRead += latestBytesRead) {
        }
        if (totalBytesRead < size) {
            LOG.warn("Journal entry was truncated. Expected to read {} bytes but only got {}", (Object)size, (Object)totalBytesRead);
            return null;
        }
        return (Journal.JournalEntry)Journal.JournalEntry.parser().parseFrom(this.mBuffer, 0, size);
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }
}

