/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.proto.journal.Journal;

public final class JournalEntryAssociation {
    public static String getMasterForEntry(Journal.JournalEntry entry) {
        if (entry.hasAddMountPoint() || entry.hasAsyncPersistRequest() || entry.hasAddSyncPoint() || entry.hasActiveSyncTxId() || entry.hasCompleteFile() || entry.hasDeleteFile() || entry.hasDeleteMountPoint() || entry.hasInodeDirectory() || entry.hasInodeDirectoryIdGenerator() || entry.hasInodeFile() || entry.hasInodeLastModificationTime() || entry.hasNewBlock() || entry.hasPersistDirectory() || entry.hasRemoveSyncPoint() || entry.hasRename() || entry.hasSetAcl() || entry.hasSetAttribute() || entry.hasUpdateUfsMode() || entry.hasUpdateInode() || entry.hasUpdateInodeDirectory() || entry.hasUpdateInodeFile()) {
            return "FileSystemMaster";
        }
        if (entry.hasBlockContainerIdGenerator() || entry.hasDeleteBlock() || entry.hasBlockInfo()) {
            return "BlockMaster";
        }
        if (entry.hasClusterInfo() || entry.hasPathProperties() || entry.hasRemovePathProperties()) {
            return "MetaMaster";
        }
        if (entry.hasAttachDb() || entry.hasAddTable() || entry.hasAddTablePartitions() || entry.hasRemoveTable() || entry.hasDetachDb() || entry.hasUpdateDatabaseInfo() || entry.hasAddTransformJobInfo() || entry.hasRemoveTransformJobInfo() || entry.hasCompleteTransformTable()) {
            return "TableMaster";
        }
        throw new IllegalStateException("Unrecognized journal entry: " + entry);
    }

    private JournalEntryAssociation() {
    }
}

