/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.GetTransferLeaderMessagePResponse;
import alluxio.grpc.JournalDomain;
import alluxio.grpc.NetAddress;
import alluxio.master.journal.JournalMaster;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.raft.RaftJournalSystem;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournalMaster
implements JournalMaster {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJournalMaster.class);
    private JournalDomain mJournalDomain;
    private JournalSystem mJournalSystem;

    public DefaultJournalMaster(JournalDomain journalDomain, JournalSystem journalSystem) {
        this.mJournalDomain = journalDomain;
        this.mJournalSystem = journalSystem;
    }

    private void checkQuorumOpSupported() {
        if (!(this.mJournalSystem instanceof RaftJournalSystem)) {
            throw new UnsupportedOperationException("Quorum operations are supported for journal type: EMBEDDED");
        }
    }

    @Override
    public GetQuorumInfoPResponse getQuorumInfo() throws IOException {
        this.checkQuorumOpSupported();
        return GetQuorumInfoPResponse.newBuilder().setDomain(this.mJournalDomain).addAllServerInfo(((RaftJournalSystem)this.mJournalSystem).getQuorumServerInfoList()).build();
    }

    @Override
    public void removeQuorumServer(NetAddress serverAddress) throws IOException {
        this.checkQuorumOpSupported();
        ((RaftJournalSystem)this.mJournalSystem).removeQuorumServer(serverAddress);
    }

    @Override
    public String transferLeadership(NetAddress newLeaderAddress) {
        this.checkQuorumOpSupported();
        return ((RaftJournalSystem)this.mJournalSystem).transferLeadership(newLeaderAddress);
    }

    @Override
    public void resetPriorities() throws IOException {
        this.checkQuorumOpSupported();
        ((RaftJournalSystem)this.mJournalSystem).resetPriorities();
    }

    @Override
    public GetTransferLeaderMessagePResponse getTransferLeaderMessage(String transferId) {
        this.checkQuorumOpSupported();
        return GetTransferLeaderMessagePResponse.newBuilder().setTransMsg(((RaftJournalSystem)this.mJournalSystem).getTransferLeaderMessage(transferId)).build();
    }
}

