/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.collections.ConcurrentHashSet;
import alluxio.master.Master;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.sink.JournalSink;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.LockResource;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractJournalSystem
implements JournalSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJournalSystem.class);
    private boolean mRunning = false;
    private final ReentrantReadWriteLock mSinkLock = new ReentrantReadWriteLock();
    private final Map<String, Set<JournalSink>> mJournalSinks = new ConcurrentHashMap<String, Set<JournalSink>>();
    private final Set<JournalSink> mAllJournalSinks = new ConcurrentHashSet();

    @Override
    public synchronized void start() throws InterruptedException, IOException {
        Preconditions.checkState((!this.mRunning ? 1 : 0) != 0, (Object)"Journal is already running");
        this.startInternal();
        this.mRunning = true;
    }

    @Override
    public synchronized void stop() throws InterruptedException, IOException {
        Preconditions.checkState((boolean)this.mRunning, (Object)"Journal is not running");
        this.mAllJournalSinks.forEach(JournalSink::beforeShutdown);
        this.mRunning = false;
        this.stopInternal();
    }

    @Override
    public void addJournalSink(Master master, JournalSink journalSink) {
        try (LockResource r = new LockResource((Lock)this.mSinkLock.writeLock());){
            this.mJournalSinks.computeIfAbsent(master.getName(), key -> new HashSet()).add(journalSink);
            this.mAllJournalSinks.add(journalSink);
        }
    }

    @Override
    public void removeJournalSink(Master master, JournalSink journalSink) {
        try (LockResource r = new LockResource((Lock)this.mSinkLock.writeLock());){
            Set<JournalSink> sinks = this.mJournalSinks.get(master.getName());
            if (sinks != null) {
                sinks.remove(journalSink);
                if (sinks.isEmpty()) {
                    this.mJournalSinks.remove(master.getName());
                }
            }
            this.mAllJournalSinks.clear();
            for (Set<JournalSink> s : this.mJournalSinks.values()) {
                this.mAllJournalSinks.addAll(s);
            }
        }
    }

    @Override
    public Set<JournalSink> getJournalSinks(@Nullable Master master) {
        try (LockResource r = new LockResource((Lock)this.mSinkLock.readLock());){
            if (master == null) {
                Set<JournalSink> set = this.mAllJournalSinks;
                return set;
            }
            Set<JournalSink> set = this.mJournalSinks.getOrDefault(master.getName(), Collections.emptySet());
            return set;
        }
    }

    protected abstract void startInternal() throws InterruptedException, IOException;

    protected abstract void stopInternal() throws InterruptedException, IOException;

    protected void registerMetrics() {
        Map<String, Long> sequenceNumber = this.getCurrentSequenceNumbers();
        for (String masterName : sequenceNumber.keySet()) {
            MetricsSystem.registerGaugeIfAbsent((String)(MetricKey.MASTER_JOURNAL_SEQUENCE_NUMBER.getName() + "." + masterName), () -> this.getCurrentSequenceNumbers().get(masterName));
        }
    }
}

