/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import java.util.OptionalLong;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJournalProgressLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJournalProgressLogger.class);
    public static final long MAX_LOG_INTERVAL_MS = 30000L;
    private long mLastMeasuredTime;
    private long mLastCommitIdx;
    private long mLogCount;
    private final OptionalLong mEndCommitIdx;

    public AbstractJournalProgressLogger(OptionalLong endComitIdx) {
        this.mEndCommitIdx = endComitIdx;
        this.mLastMeasuredTime = System.currentTimeMillis();
        this.mLastCommitIdx = 0L;
        this.mLogCount = 0L;
    }

    public abstract long getLastAppliedIndex();

    public abstract String getJournalName();

    public boolean logProgress() {
        long nextLogTime;
        long now = System.currentTimeMillis();
        if (now - this.mLastMeasuredTime < (nextLogTime = 1000L * Math.min(1L << (int)(this.mLogCount > 30L ? 30L : this.mLogCount), 30000L))) {
            return false;
        }
        long currCommitIdx = this.getLastAppliedIndex();
        long timeSinceLastMeasure = now - this.mLastMeasuredTime;
        long commitIdxRead = currCommitIdx - this.mLastCommitIdx;
        double commitIdxRateMs = (double)commitIdxRead / (double)timeSinceLastMeasure;
        StringJoiner logMsg = new StringJoiner("|");
        logMsg.add(this.getJournalName());
        logMsg.add(String.format("current SN: %d", currCommitIdx));
        logMsg.add(String.format("entries in last %dms=%d", timeSinceLastMeasure, commitIdxRead));
        if (this.mEndCommitIdx.isPresent()) {
            long commitsRemaining = this.mEndCommitIdx.getAsLong() - currCommitIdx;
            double expectedTimeRemaining = (double)commitsRemaining / commitIdxRateMs;
            if (commitsRemaining > 0L) {
                logMsg.add(String.format("est. commits left: %d", commitsRemaining));
            }
            if (!Double.isNaN(expectedTimeRemaining) && !Double.isInfinite(expectedTimeRemaining) && expectedTimeRemaining > 0.0) {
                logMsg.add(String.format("est. time remaining: %.2fms", expectedTimeRemaining));
            }
        }
        ++this.mLogCount;
        LOG.info(logMsg.toString());
        this.mLastMeasuredTime = now;
        this.mLastCommitIdx = currCommitIdx;
        return true;
    }
}

