/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCatchupThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCatchupThread.class);

    @Override
    public void run() {
        try {
            this.runCatchup();
        }
        catch (Exception e) {
            ProcessUtils.fatalError(LOG, e, "Catch-up thread is failed.", new Object[0]);
        }
    }

    public abstract void cancel();

    public void waitTermination() {
        try {
            this.join(0L);
        }
        catch (Exception e) {
            ProcessUtils.fatalError(LOG, e, "Catch-up task failed.", new Object[0]);
        }
    }

    protected abstract void runCatchup();
}

