/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.audit;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.audit.AuditContext;
import com.google.common.base.Preconditions;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AsyncUserAccessAuditLogWriter {
    private static final String AUDIT_LOG_THREAD_NAME = "AsyncUserAccessAuditLogger";
    private static final Logger LOG = LoggerFactory.getLogger(AsyncUserAccessAuditLogWriter.class);
    private final Logger mLog;
    private volatile boolean mStopped;
    private LinkedBlockingQueue<AuditContext> mAuditLogEntries;
    private Thread mLoggingWorkerThread;

    public AsyncUserAccessAuditLogWriter(String loggerName) {
        int queueCapacity = ServerConfiguration.getInt(PropertyKey.MASTER_AUDIT_LOGGING_QUEUE_CAPACITY);
        this.mAuditLogEntries = new LinkedBlockingQueue(queueCapacity);
        this.mLog = LoggerFactory.getLogger((String)loggerName);
        LOG.info("Audit logging queue capacity is {}.", (Object)queueCapacity);
        this.mStopped = true;
    }

    public synchronized void start() {
        if (this.mStopped) {
            Preconditions.checkState((this.mLoggingWorkerThread == null ? 1 : 0) != 0);
            this.mStopped = false;
            this.mLoggingWorkerThread = new Thread(new AuditLoggingWorker());
            this.mLoggingWorkerThread.setName(AUDIT_LOG_THREAD_NAME);
            this.mLoggingWorkerThread.start();
            LOG.info("AsyncUserAccessAuditLogWriter thread started.");
        }
    }

    public synchronized void stop() {
        if (!this.mStopped) {
            this.mLoggingWorkerThread.interrupt();
            try {
                this.mLoggingWorkerThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.mStopped = true;
                this.mLoggingWorkerThread = null;
                LOG.info("AsyncUserAccessAuditLogWriter thread stopped.");
            }
        }
    }

    public boolean append(AuditContext context) {
        try {
            this.mAuditLogEntries.put(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public long getAuditLogEntriesSize() {
        return this.mAuditLogEntries.size();
    }

    private class AuditLoggingWorker
    implements Runnable {
        @Override
        public void run() {
            while (!AsyncUserAccessAuditLogWriter.this.mStopped) {
                try {
                    AuditContext headContext = (AuditContext)AsyncUserAccessAuditLogWriter.this.mAuditLogEntries.take();
                    AsyncUserAccessAuditLogWriter.this.mLog.info(headContext.toString());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }
}

