/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;

public class StateLockOptions {
    private final GraceMode mGraceMode;
    private final long mGraceCycleTryMs;
    private final long mGraceCycleSleepMs;
    private final long mGraceCycleTimeoutMs;

    public StateLockOptions(GraceMode graceMode, long graceCycleTryMs, long graceCycleSleepMs, long graceCycleTimeoutMs) {
        this.mGraceMode = graceMode;
        this.mGraceCycleTryMs = graceCycleTryMs;
        this.mGraceCycleSleepMs = graceCycleSleepMs;
        this.mGraceCycleTimeoutMs = graceCycleTimeoutMs;
    }

    public GraceMode getGraceMode() {
        return this.mGraceMode;
    }

    public long getGraceCycleTryMs() {
        return this.mGraceCycleTryMs;
    }

    public long getGraceCycleSleepMs() {
        return this.mGraceCycleSleepMs;
    }

    public long getGraceCycleTimeoutMs() {
        return this.mGraceCycleTimeoutMs;
    }

    public static StateLockOptions defaultsForShellBackup() {
        return new StateLockOptions(ServerConfiguration.getEnum(PropertyKey.MASTER_SHELL_BACKUP_STATE_LOCK_GRACE_MODE, GraceMode.class), ServerConfiguration.getMs(PropertyKey.MASTER_SHELL_BACKUP_STATE_LOCK_TRY_DURATION), ServerConfiguration.getMs(PropertyKey.MASTER_SHELL_BACKUP_STATE_LOCK_SLEEP_DURATION), ServerConfiguration.getMs(PropertyKey.MASTER_SHELL_BACKUP_STATE_LOCK_TIMEOUT));
    }

    public static StateLockOptions defaultsForDailyBackup() {
        return new StateLockOptions(ServerConfiguration.getEnum(PropertyKey.MASTER_DAILY_BACKUP_STATE_LOCK_GRACE_MODE, GraceMode.class), ServerConfiguration.getMs(PropertyKey.MASTER_DAILY_BACKUP_STATE_LOCK_TRY_DURATION), ServerConfiguration.getMs(PropertyKey.MASTER_DAILY_BACKUP_STATE_LOCK_SLEEP_DURATION), ServerConfiguration.getMs(PropertyKey.MASTER_DAILY_BACKUP_STATE_LOCK_TIMEOUT));
    }

    public static StateLockOptions defaults() {
        return new StateLockOptions(GraceMode.FORCED, 0L, 0L, 0L);
    }

    public static enum GraceMode {
        TIMEOUT,
        FORCED;

    }
}

