/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.AbstractPrimarySelector;
import alluxio.master.PrimarySelector;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.SessionConnectionStateErrorPolicy;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class PrimarySelectorClient
extends AbstractPrimarySelector
implements LeaderSelectorListener {
    private static final Logger LOG = LoggerFactory.getLogger(PrimarySelectorClient.class);
    private static final int NOT_A_LEADER = -1;
    private final String mElectionPath;
    private final String mLeaderFolder;
    private final LeaderSelector mLeaderSelector;
    private String mName;
    private final String mZookeeperAddress;
    private long mLeaderZkSessionId;
    private final ZookeeperConnectionErrorPolicy mConnectionErrorPolicy;
    private LifecycleState mLifecycleState = LifecycleState.INIT;

    public PrimarySelectorClient(String zookeeperAddress, String electionPath, String leaderPath) {
        this.mZookeeperAddress = zookeeperAddress;
        this.mElectionPath = electionPath;
        this.mLeaderFolder = leaderPath.endsWith("/") ? leaderPath : leaderPath + "/";
        this.mConnectionErrorPolicy = ServerConfiguration.getEnum(PropertyKey.ZOOKEEPER_LEADER_CONNECTION_ERROR_POLICY, ZookeeperConnectionErrorPolicy.class);
        this.mLeaderZkSessionId = -1L;
        this.mLeaderSelector = new LeaderSelector(this.getNewCuratorClient(), this.mElectionPath, (LeaderSelectorListener)this);
        this.mLeaderSelector.autoRequeue();
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.mLifecycleState == LifecycleState.STARTED) {
            this.mLeaderSelector.close();
        }
        this.mLifecycleState = LifecycleState.STOPPED;
    }

    public String getName() {
        return this.mName;
    }

    public List<String> getParticipants() {
        try {
            ArrayList participants = new ArrayList(this.mLeaderSelector.getParticipants());
            ArrayList<String> results = new ArrayList<String>();
            for (Participant part : participants) {
                results.add(part.getId());
            }
            return results;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized void start(InetSocketAddress address) throws IOException {
        Preconditions.checkState((this.mLifecycleState == LifecycleState.INIT ? 1 : 0) != 0, (Object)("Failed to transition from INIT to STARTED: current state is " + (Object)((Object)this.mLifecycleState)));
        this.mLifecycleState = LifecycleState.STARTED;
        this.mName = address.getHostName() + ":" + address.getPort();
        this.mLeaderSelector.setId(this.mName);
        this.mLeaderSelector.start();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.mConnectionErrorPolicy == ZookeeperConnectionErrorPolicy.SESSION) {
            this.handleStateChangeSession(client, newState);
        } else {
            this.handleStateChangeStandard(client, newState);
        }
        if (newState != ConnectionState.LOST && newState != ConnectionState.SUSPENDED) {
            try {
                String leaderId = this.mLeaderSelector.getLeader().getId();
                if (!leaderId.isEmpty()) {
                    LOG.info("The current leader is {}", (Object)leaderId);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleStateChangeStandard(CuratorFramework client, ConnectionState newState) {
        this.setState(PrimarySelector.State.STANDBY);
    }

    private void handleStateChangeSession(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case LOST: {
                this.setState(PrimarySelector.State.STANDBY);
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                if (this.getState() != PrimarySelector.State.PRIMARY) break;
                try {
                    long reconnectSessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
                    if (this.mLeaderZkSessionId != reconnectSessionId) {
                        LOG.warn(String.format("Curator reconnected under a different session. Old sessionId: %x, New sessionId: %x", this.mLeaderZkSessionId, reconnectSessionId));
                        this.setState(PrimarySelector.State.STANDBY);
                        break;
                    }
                    LOG.info(String.format("Retaining leader state after zookeeper reconnected with sessionId: %x.", reconnectSessionId));
                }
                catch (Exception e) {
                    LOG.warn("Cannot query session Id after session is reconnected.", (Throwable)e);
                    this.setState(PrimarySelector.State.STANDBY);
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected state: %s", newState));
            }
        }
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        this.setState(PrimarySelector.State.PRIMARY);
        if (client.checkExists().forPath(this.mLeaderFolder + this.mName) != null) {
            LOG.info("Deleting zk path: {}{}", (Object)this.mLeaderFolder, (Object)this.mName);
            client.delete().forPath(this.mLeaderFolder + this.mName);
        }
        LOG.info("Creating zk path: {}{}", (Object)this.mLeaderFolder, (Object)this.mName);
        ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.mLeaderFolder + this.mName);
        LOG.info("{} is now the leader.", (Object)this.mName);
        try {
            this.mLeaderZkSessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
            LOG.info(String.format("Taken leadership under session Id: %x", this.mLeaderZkSessionId));
            this.waitForState(PrimarySelector.State.STANDBY);
        }
        finally {
            LOG.warn("{} relinquishing leadership.", (Object)this.mName);
            LOG.info("The current leader is {}", (Object)this.mLeaderSelector.getLeader().getId());
            LOG.info("All participants: {}", (Object)this.mLeaderSelector.getParticipants());
            client.delete().forPath(this.mLeaderFolder + this.mName);
            this.mLeaderZkSessionId = -1L;
        }
    }

    private CuratorFramework getNewCuratorClient() {
        LOG.info("Creating new zookeeper client for primary selector {}", (Object)this.mZookeeperAddress);
        CuratorFrameworkFactory.Builder curatorBuilder = CuratorFrameworkFactory.builder();
        curatorBuilder.connectString(this.mZookeeperAddress);
        curatorBuilder.retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        curatorBuilder.sessionTimeoutMs((int)ServerConfiguration.getMs(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT));
        curatorBuilder.connectionTimeoutMs((int)ServerConfiguration.getMs(PropertyKey.ZOOKEEPER_CONNECTION_TIMEOUT));
        curatorBuilder.zk34CompatibilityMode(true);
        curatorBuilder.dontUseContainerParents();
        if (this.mConnectionErrorPolicy == ZookeeperConnectionErrorPolicy.SESSION) {
            curatorBuilder.connectionStateErrorPolicy((ConnectionStateErrorPolicy)new SessionConnectionStateErrorPolicy());
        }
        CuratorFramework client = curatorBuilder.build();
        client.start();
        client.close();
        client = curatorBuilder.build();
        client.start();
        return client;
    }

    protected static enum ZookeeperConnectionErrorPolicy {
        STANDARD,
        SESSION;

    }

    private static enum LifecycleState {
        INIT,
        STARTED,
        STOPPED;

    }
}

