/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.PrimarySelectorClient;
import alluxio.util.interfaces.Scoped;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Consumer;

public interface PrimarySelector {
    public void start(InetSocketAddress var1) throws IOException;

    public void stop() throws IOException;

    public State getState();

    public Scoped onStateChange(Consumer<State> var1);

    public void waitForState(State var1) throws InterruptedException;

    public static final class Factory {
        public static PrimarySelector createZkPrimarySelector() {
            String zkAddress = ServerConfiguration.get(PropertyKey.ZOOKEEPER_ADDRESS);
            String zkElectionPath = ServerConfiguration.get(PropertyKey.ZOOKEEPER_ELECTION_PATH);
            String zkLeaderPath = ServerConfiguration.get(PropertyKey.ZOOKEEPER_LEADER_PATH);
            return new PrimarySelectorClient(zkAddress, zkElectionPath, zkLeaderPath);
        }

        public static PrimarySelector createZkJobPrimarySelector() {
            String zkAddress = ServerConfiguration.get(PropertyKey.ZOOKEEPER_ADDRESS);
            String zkElectionPath = ServerConfiguration.get(PropertyKey.ZOOKEEPER_JOB_ELECTION_PATH);
            String zkLeaderPath = ServerConfiguration.get(PropertyKey.ZOOKEEPER_JOB_LEADER_PATH);
            return new PrimarySelectorClient(zkAddress, zkElectionPath, zkLeaderPath);
        }

        private Factory() {
        }
    }

    public static enum State {
        PRIMARY,
        STANDBY;

    }
}

