/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Process;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.master.Master;
import alluxio.master.journal.JournalSystem;
import alluxio.metrics.MetricsSystem;
import alluxio.network.RejectingServer;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.WebServer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MasterProcess
implements Process {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcess.class);
    protected final JournalSystem mJournalSystem;
    final InetSocketAddress mRpcBindAddress;
    final InetSocketAddress mWebBindAddress;
    final long mStartTimeMs = System.currentTimeMillis();
    private RejectingServer mRejectingRpcServer;
    private RejectingServer mRejectingWebServer;
    protected GrpcServer mGrpcServer;
    protected WebServer mWebServer;

    public MasterProcess(JournalSystem journalSystem, NetworkAddressUtils.ServiceType rpcService, NetworkAddressUtils.ServiceType webService) {
        this.mJournalSystem = (JournalSystem)Preconditions.checkNotNull((Object)journalSystem, (Object)"journalSystem");
        this.mRpcBindAddress = MasterProcess.configureAddress(rpcService);
        this.mWebBindAddress = MasterProcess.configureAddress(webService);
    }

    private static InetSocketAddress configureAddress(NetworkAddressUtils.ServiceType service) {
        InstancedConfiguration conf = ServerConfiguration.global();
        int port = NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)conf);
        if (!ConfigurationUtils.isHaMode((AlluxioConfiguration)conf) && port == 0) {
            throw new RuntimeException(String.format("%s port must be nonzero in single-master mode", service));
        }
        if (port == 0) {
            try (ServerSocket s = new ServerSocket(0);){
                s.setReuseAddress(true);
                conf.set(service.getPortKey(), (Object)s.getLocalPort());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)conf);
    }

    public abstract InetSocketAddress getRpcAddress();

    public abstract <T extends Master> T getMaster(Class<T> var1);

    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    protected void startServing() {
        this.startServing("", "");
    }

    abstract void startServing(String var1, String var2);

    public long getUptimeMs() {
        return System.currentTimeMillis() - this.mStartTimeMs;
    }

    public abstract InetSocketAddress getWebAddress();

    public boolean isGrpcServing() {
        return this.mGrpcServer != null && this.mGrpcServer.isServing();
    }

    public boolean isWebServing() {
        return this.mWebServer != null && this.mWebServer.getServer().isRunning();
    }

    public boolean isMetricSinkServing() {
        return MetricsSystem.isStarted();
    }

    void registerServices(GrpcServerBuilder serverBuilder, Map<ServiceType, GrpcService> services) {
        for (Map.Entry<ServiceType, GrpcService> serviceEntry : services.entrySet()) {
            serverBuilder.addService(serviceEntry.getKey(), serviceEntry.getValue());
            LOG.info("registered service {}", (Object)serviceEntry.getKey().name());
        }
    }

    public boolean waitForGrpcServerReady(int timeoutMs) {
        try {
            CommonUtils.waitFor((String)(this + " to start"), () -> {
                boolean ready = this.isGrpcServing();
                if (ready && !ServerConfiguration.getBoolean(PropertyKey.TEST_MODE)) {
                    ready &= this.mWebServer != null && this.mWebServer.getServer().isRunning();
                }
                return ready;
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean waitForReady(int timeoutMs) {
        return this.waitForGrpcServerReady(timeoutMs);
    }

    protected void startRejectingServers() {
        if (this.mRejectingRpcServer == null) {
            this.mRejectingRpcServer = new RejectingServer(this.mRpcBindAddress);
            this.mRejectingRpcServer.start();
        }
        if (!this.isWebServing() && this.mRejectingWebServer == null) {
            this.mRejectingWebServer = new RejectingServer(this.mWebBindAddress);
            this.mRejectingWebServer.start();
        }
    }

    protected void stopRejectingRpcServer() {
        if (this.mRejectingRpcServer != null) {
            this.mRejectingRpcServer.stopAndJoin();
            this.mRejectingRpcServer = null;
        }
    }

    protected void stopRejectingWebServer() {
        if (this.mRejectingWebServer != null) {
            this.mRejectingWebServer.stopAndJoin();
            this.mRejectingWebServer = null;
        }
    }

    protected void stopRejectingServers() {
        this.stopRejectingRpcServer();
        this.stopRejectingWebServer();
    }
}

