/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.StateLockManager;
import alluxio.master.journal.JournalSystem;
import alluxio.security.user.ServerUserState;
import alluxio.security.user.UserState;
import alluxio.underfs.UfsManager;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class MasterContext<T extends UfsManager> {
    private final JournalSystem mJournalSystem;
    private final StateLockManager mStateLockManager;
    private final UserState mUserState;
    private final T mUfsManager;

    public MasterContext(JournalSystem journalSystem, T ufsManager) {
        this(journalSystem, null, ufsManager);
    }

    public MasterContext(JournalSystem journalSystem, @Nullable UserState userState, T ufsManager) {
        this.mJournalSystem = (JournalSystem)Preconditions.checkNotNull((Object)journalSystem, (Object)"journalSystem");
        this.mUfsManager = (UfsManager)Preconditions.checkNotNull(ufsManager, (Object)"ufsManager");
        this.mUserState = userState == null ? ServerUserState.global() : userState;
        this.mStateLockManager = new StateLockManager();
    }

    public JournalSystem getJournalSystem() {
        return this.mJournalSystem;
    }

    public UserState getUserState() {
        return this.mUserState;
    }

    public StateLockManager getStateLockManager() {
        return this.mStateLockManager;
    }

    public T getUfsManager() {
        return this.mUfsManager;
    }
}

