/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.concurrent.jsr.ForkJoinPool;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AlluxioExecutorService
implements ExecutorService {
    private ExecutorService mExecutor;

    public AlluxioExecutorService(ExecutorService executor) {
        this.mExecutor = executor;
    }

    public long getRpcQueueLength() {
        if (this.mExecutor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.mExecutor).getQueue().size();
        }
        if (this.mExecutor instanceof ForkJoinPool) {
            return ((ForkJoinPool)this.mExecutor).getQueuedSubmissionCount();
        }
        throw new IllegalArgumentException(String.format("Not supported internal executor: %s", this.mExecutor.getClass().getName()));
    }

    @Override
    public void shutdown() {
        this.mExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.mExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.mExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.mExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.mExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.mExecutor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.mExecutor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.mExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.mExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return null;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.mExecutor.execute(command);
    }
}

