/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.PrimarySelector;
import alluxio.resource.LockResource;
import alluxio.util.interfaces.Scoped;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractPrimarySelector
implements PrimarySelector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrimarySelector.class);
    @GuardedBy(value="mListeners")
    private final Set<AtomicReference<Consumer<PrimarySelector.State>>> mListeners = new HashSet<AtomicReference<Consumer<PrimarySelector.State>>>();
    private final Lock mStateLock = new ReentrantLock();
    private final Condition mStateCond = this.mStateLock.newCondition();
    @GuardedBy(value="mStateLock")
    private PrimarySelector.State mState = PrimarySelector.State.STANDBY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(PrimarySelector.State state) {
        try (LockResource lr = new LockResource(this.mStateLock);){
            this.mState = state;
            this.mStateCond.signalAll();
            Set<AtomicReference<Consumer<PrimarySelector.State>>> set = this.mListeners;
            synchronized (set) {
                this.mListeners.forEach(listener -> ((Consumer)listener.get()).accept(state));
            }
            LOG.info("Primary selector transitioning to {}", (Object)state);
        }
    }

    @Override
    public final PrimarySelector.State getState() {
        try (LockResource lr = new LockResource(this.mStateLock);){
            PrimarySelector.State state = this.mState;
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Scoped onStateChange(Consumer<PrimarySelector.State> listener) {
        AtomicReference<Consumer<PrimarySelector.State>> listenerRef = new AtomicReference<Consumer<PrimarySelector.State>>(listener);
        Set<AtomicReference<Consumer<PrimarySelector.State>>> set = this.mListeners;
        synchronized (set) {
            Preconditions.checkState((boolean)this.mListeners.add(listenerRef), (Object)"listener already exists");
        }
        return () -> {
            Set<AtomicReference<Consumer<PrimarySelector.State>>> set = this.mListeners;
            synchronized (set) {
                this.mListeners.remove(listenerRef);
            }
        };
    }

    @Override
    public final void waitForState(PrimarySelector.State state) throws InterruptedException {
        try (LockResource lr = new LockResource(this.mStateLock);){
            while (this.mState != state) {
                this.mStateCond.await();
            }
        }
    }
}

