/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Server;
import alluxio.exception.status.UnavailableException;
import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalContext;
import alluxio.master.journal.StateChangeJournalContext;
import alluxio.resource.LockResource;
import alluxio.util.executor.ExecutorServiceFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractMaster
implements Master {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMaster.class);
    private static final long SHUTDOWN_TIMEOUT_MS = 10000L;
    private ExecutorServiceFactory mExecutorServiceFactory;
    private ExecutorService mExecutorService;
    private Journal mJournal;
    private boolean mIsPrimary = false;
    protected final Clock mClock;
    protected final MasterContext mMasterContext;

    protected AbstractMaster(MasterContext masterContext, Clock clock, ExecutorServiceFactory executorServiceFactory) {
        Preconditions.checkNotNull((Object)masterContext, (Object)"masterContext");
        this.mMasterContext = masterContext;
        this.mClock = clock;
        this.mExecutorServiceFactory = executorServiceFactory;
        this.mJournal = masterContext.getJournalSystem().createJournal(this);
    }

    public Set<Class<? extends Server>> getDependencies() {
        return Collections.emptySet();
    }

    public void start(Boolean isPrimary) throws IOException {
        Preconditions.checkState((this.mExecutorService == null ? 1 : 0) != 0);
        this.mExecutorService = this.mExecutorServiceFactory.create();
        this.mIsPrimary = isPrimary;
        if (this.mIsPrimary) {
            LOG.info("{}: Starting primary master.", (Object)this.getName());
        }
    }

    public void stop() throws IOException {
        if (this.mIsPrimary) {
            LOG.info("{}: Stopping primary master.", (Object)this.getName());
        }
        if (this.mExecutorService != null) {
            try {
                this.mExecutorService.shutdownNow();
                String awaitFailureMessage = "waiting for {} executor service to shut down. Daemons may still be running";
                try {
                    if (!this.mExecutorService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        LOG.warn("Timed out " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted while " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
                }
            }
            finally {
                this.mExecutorService = null;
            }
        }
        LOG.info("{}: Stopped {} master.", (Object)this.getName(), (Object)(this.mIsPrimary ? "primary" : "standby"));
    }

    protected ExecutorService getExecutorService() {
        return this.mExecutorService;
    }

    @Override
    public JournalContext createJournalContext() throws UnavailableException {
        LockResource sharedLockResource;
        try {
            sharedLockResource = this.mMasterContext.getStateLockManager().lockShared();
        }
        catch (InterruptedException e) {
            throw new UnavailableException("Failed to acquire state-lock due to ongoing backup activity.");
        }
        try {
            return new StateChangeJournalContext(this.mJournal.createJournalContext(), sharedLockResource);
        }
        catch (UnavailableException e) {
            sharedLockResource.close();
            throw e;
        }
    }

    public void close() throws IOException {
        this.stop();
    }

    @Override
    public MasterContext getMasterContext() {
        return this.mMasterContext;
    }
}

