/*
 * Decompiled with CFR 0.152.
 */
package alluxio.executor;

import alluxio.concurrent.jsr.ForkJoinPool;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.AlluxioExecutorService;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Preconditions;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceBuilder {
    public static AlluxioExecutorService buildExecutorService(RpcExecutorHost executorHost) {
        RpcExecutorType executorType = ServerConfiguration.getEnum(PropertyKey.Template.RPC_EXECUTOR_TYPE.format(new Object[]{executorHost.toString()}), RpcExecutorType.class);
        String threadNameFormat = String.format("%s-rpc-executor-%s-thread", new Object[]{executorHost, executorType}) + "-%d";
        int corePoolSize = ServerConfiguration.getInt(PropertyKey.Template.RPC_EXECUTOR_CORE_POOL_SIZE.format(new Object[]{executorHost.toString()}));
        int maxPoolSize = ServerConfiguration.getInt(PropertyKey.Template.RPC_EXECUTOR_MAX_POOL_SIZE.format(new Object[]{executorHost.toString()}));
        long keepAliveMs = ServerConfiguration.getMs(PropertyKey.Template.RPC_EXECUTOR_KEEPALIVE.format(new Object[]{executorHost.toString()}));
        Preconditions.checkArgument((keepAliveMs > 0L ? 1 : 0) != 0, (Object)String.format("Cannot start Alluxio %s gRPC thread pool with %s=%s. The keepalive time must be greater than 0!", new Object[]{executorHost, PropertyKey.Template.RPC_EXECUTOR_KEEPALIVE.format(new Object[]{executorHost.toString()}), keepAliveMs}));
        ThreadPoolExecutor executorService = null;
        if (executorType == RpcExecutorType.FJP) {
            int parallelism = ServerConfiguration.getInt(PropertyKey.Template.RPC_EXECUTOR_FJP_PARALLELISM.format(new Object[]{executorHost.toString()}));
            int minRunnable = ServerConfiguration.getInt(PropertyKey.Template.RPC_EXECUTOR_FJP_MIN_RUNNABLE.format(new Object[]{executorHost.toString()}));
            boolean isAsync = ServerConfiguration.getBoolean(PropertyKey.Template.RPC_EXECUTOR_FJP_ASYNC.format(new Object[]{executorHost.toString()}));
            Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0, (Object)String.format("Cannot start Alluxio %s gRPC thread pool with %s=%s! The parallelism must be greater than 0!", new Object[]{executorHost, PropertyKey.Template.RPC_EXECUTOR_FJP_PARALLELISM.format(new Object[]{executorHost.toString()}), parallelism}));
            Preconditions.checkArgument((parallelism <= maxPoolSize ? 1 : 0) != 0, (Object)String.format("Cannot start Alluxio %s gRPC thread pool with %s=%s greater than %s=%s!", new Object[]{executorHost, PropertyKey.Template.RPC_EXECUTOR_FJP_PARALLELISM.format(new Object[]{executorHost.toString()}), parallelism, PropertyKey.MASTER_RPC_EXECUTOR_MAX_POOL_SIZE.toString(), maxPoolSize}));
            executorService = new ForkJoinPool(parallelism, ThreadFactoryUtils.buildFjp((String)threadNameFormat, (boolean)true), null, isAsync, corePoolSize, maxPoolSize, minRunnable, null, keepAliveMs, TimeUnit.MILLISECONDS);
        } else {
            boolean allowCoreThreadsTimeout = ServerConfiguration.getBoolean(PropertyKey.Template.RPC_EXECUTOR_TPE_ALLOW_CORE_THREADS_TIMEOUT.format(new Object[]{executorHost.toString()}));
            ThreadPoolExecutorQueueType queueType = ServerConfiguration.getEnum(PropertyKey.Template.RPC_EXECUTOR_TPE_QUEUE_TYPE.format(new Object[]{executorHost.toString()}), ThreadPoolExecutorQueueType.class);
            LinkedBlockingQueue<Runnable> queue = null;
            switch (queueType) {
                case LINKED_BLOCKING_QUEUE: {
                    queue = new LinkedBlockingQueue();
                    break;
                }
                case LINKED_BLOCKING_QUEUE_WITH_CAP: {
                    queue = new LinkedBlockingQueue(maxPoolSize);
                    break;
                }
                case ARRAY_BLOCKING_QUEUE: {
                    queue = new ArrayBlockingQueue(maxPoolSize);
                    break;
                }
                case SYNCHRONOUS_BLOCKING_QUEUE: {
                    queue = new SynchronousQueue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported internal queue type: %s", new Object[]{queueType}));
                }
            }
            executorService = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveMs, TimeUnit.MILLISECONDS, queue, ThreadFactoryUtils.build((String)threadNameFormat, (boolean)true));
            executorService.allowCoreThreadTimeOut(allowCoreThreadsTimeout);
        }
        return new AlluxioExecutorService(executorService);
    }

    public static enum ThreadPoolExecutorQueueType {
        LINKED_BLOCKING_QUEUE,
        LINKED_BLOCKING_QUEUE_WITH_CAP,
        ARRAY_BLOCKING_QUEUE,
        SYNCHRONOUS_BLOCKING_QUEUE;

    }

    public static enum RpcExecutorType {
        TPE,
        FJP;

    }

    public static enum RpcExecutorHost {
        MASTER(0),
        JOB_MASTER(1),
        WORKER(2);

        private final int mValue;

        private RpcExecutorHost(int value) {
            this.mValue = value;
        }

        public String toString() {
            switch (this.mValue) {
                case 0: {
                    return "master";
                }
                case 1: {
                    return "job.master";
                }
                case 2: {
                    return "worker";
                }
            }
            return "<unrecognized_rpc_host>";
        }
    }
}

