/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.Scope;
import alluxio.util.ConfigurationUtils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConfiguration.class);
    private static InstancedConfiguration sConf;

    public static void reset() {
        ConfigurationUtils.reloadProperties();
        sConf = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    public static AlluxioProperties copyProperties() {
        return new AlluxioProperties(sConf.copyProperties());
    }

    public static void merge(Map<?, ?> properties, Source source) {
        sConf.merge(properties, source);
    }

    public static void set(PropertyKey key, Object value) {
        ServerConfiguration.set(key, String.valueOf(value), Source.RUNTIME);
    }

    public static void set(PropertyKey key, Object value, Source source) {
        sConf.set(key, value, source);
    }

    public static void unset(PropertyKey key) {
        sConf.unset(key);
    }

    public static String get(PropertyKey key) {
        return sConf.get(key);
    }

    public static String get(PropertyKey key, ConfigurationValueOptions options) {
        return sConf.get(key, options);
    }

    public static String getOrDefault(PropertyKey key, String defaultValue) {
        return sConf.getOrDefault(key, defaultValue);
    }

    public static String getOrDefault(PropertyKey key, String defaultValue, ConfigurationValueOptions options) {
        return sConf.getOrDefault(key, defaultValue, options);
    }

    public static boolean isSet(PropertyKey key) {
        return sConf.isSet(key);
    }

    public static boolean isSetByUser(PropertyKey key) {
        return sConf.isSetByUser(key);
    }

    public static Set<PropertyKey> keySet() {
        return sConf.keySet();
    }

    public static int getInt(PropertyKey key) {
        return sConf.getInt(key);
    }

    public static long getLong(PropertyKey key) {
        return sConf.getLong(key);
    }

    public static double getDouble(PropertyKey key) {
        return sConf.getDouble(key);
    }

    public static float getFloat(PropertyKey key) {
        return sConf.getFloat(key);
    }

    public static boolean getBoolean(PropertyKey key) {
        return sConf.getBoolean(key);
    }

    public static List<String> getList(PropertyKey key, String delimiter) {
        return sConf.getList(key, delimiter);
    }

    public static <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        return (T)sConf.getEnum(key, enumType);
    }

    public static long getBytes(PropertyKey key) {
        return sConf.getBytes(key);
    }

    public static long getMs(PropertyKey key) {
        return sConf.getMs(key);
    }

    public static Duration getDuration(PropertyKey key) {
        return sConf.getDuration(key);
    }

    public static <T> Class<T> getClass(PropertyKey key) {
        return sConf.getClass(key);
    }

    public static Map<String, String> getNestedProperties(PropertyKey prefixKey) {
        return sConf.getNestedProperties(prefixKey);
    }

    public static Source getSource(PropertyKey key) {
        return sConf.getSource(key);
    }

    public static Map<String, String> toMap() {
        return sConf.toMap();
    }

    public static Map<String, String> toMap(ConfigurationValueOptions opts) {
        return sConf.toMap(opts);
    }

    public static InstancedConfiguration global() {
        return sConf;
    }

    public static synchronized void loadWorkerClusterDefaults(InetSocketAddress address) throws AlluxioStatusException {
        if (sConf.getBoolean(PropertyKey.USER_CONF_CLUSTER_DEFAULT_ENABLED) && !sConf.clusterDefaultsLoaded()) {
            GetConfigurationPResponse response = ConfigurationUtils.loadConfiguration((InetSocketAddress)address, (AlluxioConfiguration)sConf, (boolean)false, (boolean)true);
            AlluxioConfiguration conf = ConfigurationUtils.getClusterConf((GetConfigurationPResponse)response, (AlluxioConfiguration)sConf, (Scope)Scope.WORKER);
            sConf = new InstancedConfiguration(conf.copyProperties(), conf.clusterDefaultsLoaded());
        }
    }

    public static String hash() {
        return sConf.hash();
    }

    private ServerConfiguration() {
    }

    static {
        ServerConfiguration.reset();
    }
}

