/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.extensions.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ShellUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UninstallCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(UninstallCommand.class);

    public String getCommandName() {
        return "uninstall";
    }

    public String getUsage() {
        return "uninstall <JAR>";
    }

    public String getDescription() {
        return "Uninstalls an extension from hosts configured in conf/masters and conf/workers.";
    }

    public int run(CommandLine cl) {
        String uri = cl.getArgs()[0];
        InstancedConfiguration conf = ServerConfiguration.global();
        String extensionsDir = conf.get(PropertyKey.EXTENSIONS_DIR);
        ArrayList<String> failedHosts = new ArrayList<String>();
        for (String host : ConfigurationUtils.getServerHostnames((AlluxioConfiguration)conf)) {
            try {
                LOG.info("Attempting to uninstall extension on host {}", (Object)host);
                String rmCmd = String.format("ssh %s %s rm %s", "-o StrictHostKeyChecking=no -o ConnectTimeout=5", host, PathUtils.concatPath((Object)extensionsDir, (Object)uri));
                LOG.debug("Executing: {}", (Object)rmCmd);
                String output = ShellUtils.execCommand((String[])new String[]{"bash", "-c", rmCmd});
                LOG.debug("Succeeded w/ output: {}", (Object)output);
            }
            catch (IOException e) {
                LOG.error("Error uninstalling extension on host {}.", (Object)host, (Object)e);
                failedHosts.add(host);
            }
        }
        if (failedHosts.size() != 0) {
            System.err.println("Failed to uninstall extension on hosts:");
            for (String failedHost : failedHosts) {
                System.err.println(failedHost);
            }
            return -1;
        }
        System.out.println("Extension uninstalled successfully.");
        return 0;
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        String[] args = cl.getArgs();
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
        if (args[0] == null) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NULL.getMessage(new Object[]{this.getCommandName()}));
        }
        if (!args[0].endsWith(".jar")) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_EXTENSION_NOT_JAR.getMessage(new Object[]{args[0]}));
        }
    }
}

