/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.extensions.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.ExtensionUtils;
import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LsCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(LsCommand.class);

    public String getCommandName() {
        return "ls";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public String getUsage() {
        return "ls";
    }

    public String getDescription() {
        return "Lists JAR names for all installed extensions.";
    }

    public int run(CommandLine cl) {
        for (File extension : ExtensionUtils.listExtensions((String)ServerConfiguration.get(PropertyKey.EXTENSIONS_DIR))) {
            System.out.println(extension.getName());
        }
        return 0;
    }
}

