/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.master.NoopMaster;
import alluxio.master.NoopUfsManager;
import alluxio.master.ServiceUtils;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.JournalUtils;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.io.FileUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class Format {
    private static final Logger LOG = LoggerFactory.getLogger(Format.class);
    private static final String USAGE = String.format("java -cp %s %s <MASTER/WORKER>", "target/alluxio-2.7.3-jar-with-dependencies.jar", Format.class.getCanonicalName());

    private static void formatWorkerDataFolder(String folder) throws IOException {
        Path path = Paths.get(folder, new String[0]);
        FileUtils.deletePathRecursively((String)folder);
        Files.createDirectory(path, new FileAttribute[0]);
        String permissions = ServerConfiguration.get(PropertyKey.WORKER_DATA_FOLDER_PERMISSIONS);
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString(permissions);
        Files.setPosixFilePermissions(path, perms);
        FileUtils.setLocalDirStickyBit((String)path.toAbsolutePath().toString());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            LOG.info(USAGE);
            System.exit(-1);
        }
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.MASTER);
        Mode mode = null;
        try {
            mode = Mode.valueOf(args[0].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unrecognized format mode: {}", (Object)args[0]);
            LOG.error("Usage: {}", (Object)USAGE);
            System.exit(-1);
        }
        try {
            Format.format(mode, (AlluxioConfiguration)conf);
        }
        catch (Exception e) {
            LOG.error("Failed to format", (Throwable)e);
            System.exit(-1);
        }
        LOG.info("Formatting complete");
        System.exit(0);
    }

    public static void format(Mode mode, AlluxioConfiguration alluxioConf) throws IOException {
        NoopUfsManager noopUfsManager = new NoopUfsManager();
        switch (mode) {
            case MASTER: {
                URI journalLocation = JournalUtils.getJournalLocation();
                LOG.info("Formatting master journal: {}", (Object)journalLocation);
                JournalSystem journalSystem = new JournalSystem.Builder().setLocation(journalLocation).build(CommonUtils.ProcessType.MASTER);
                for (String masterServiceName : ServiceUtils.getMasterServiceNames()) {
                    journalSystem.createJournal(new NoopMaster(masterServiceName, noopUfsManager));
                }
                journalSystem.format();
                break;
            }
            case WORKER: {
                String workerDataFolder = ServerConfiguration.get(PropertyKey.WORKER_DATA_FOLDER);
                LOG.info("Formatting worker data folder: {}", (Object)workerDataFolder);
                int storageLevels = ServerConfiguration.getInt(PropertyKey.WORKER_TIERED_STORE_LEVELS);
                for (int level = 0; level < storageLevels; ++level) {
                    PropertyKey tierLevelDirPath = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH.format(new Object[]{level});
                    String[] dirPaths = ServerConfiguration.get(tierLevelDirPath).split(",");
                    String name = "Data path for tier " + level;
                    for (String dirPath : dirPaths) {
                        String dirWorkerDataFolder = CommonUtils.getWorkerDataDirectory((String)dirPath, (AlluxioConfiguration)alluxioConf);
                        LOG.info("Formatting {}:{}", (Object)name, (Object)dirWorkerDataFolder);
                        Format.formatWorkerDataFolder(dirWorkerDataFolder);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unrecognized format mode: %s", new Object[]{mode}));
            }
        }
    }

    private Format() {
    }

    public static enum Mode {
        MASTER,
        WORKER;

    }
}

