/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.RpcSensitiveConfigMask;
import alluxio.conf.SensitiveConfigMask;
import alluxio.exception.AlluxioException;
import alluxio.metrics.Metric;
import alluxio.metrics.MetricsSystem;
import alluxio.security.User;
import alluxio.security.authentication.AuthenticatedClientUser;
import com.codahale.metrics.Timer;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.slf4j.Logger;

public final class RpcUtils {
    public static final SensitiveConfigMask SENSITIVE_CONFIG_MASKER = RpcSensitiveConfigMask.CREDENTIAL_FIELD_MASKER;

    private RpcUtils() {
    }

    public static <T> void call(Logger logger, RpcCallableThrowsIOException<T> callable, String methodName, String description, StreamObserver<T> responseObserver, Object ... args) {
        RpcUtils.call(logger, callable, methodName, false, description, responseObserver, args);
    }

    public static <T> void call(Logger logger, RpcCallableThrowsIOException<T> callable, String methodName, boolean failureOk, String description, StreamObserver<T> responseObserver, Object ... args) {
        T response;
        try {
            response = RpcUtils.callAndReturn(logger, callable, methodName, failureOk, description, args);
        }
        catch (StatusException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    /*
     * Exception decompiling
     */
    public static <T> T callAndReturn(Logger logger, RpcCallableThrowsIOException<T> callable, String methodName, boolean failureOk, String description, Object ... args) throws StatusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void streamingRPCAndLog(Logger logger, StreamingRpcCallable<T> callable, String methodName, boolean sendResponse, boolean completeResponse, StreamObserver<T> responseObserver, String description, Object ... args) {
        String debugDesc = logger.isDebugEnabled() ? String.format(description, RpcUtils.processObjects(logger, args)) : null;
        try (Timer.Context ctx = MetricsSystem.timer((String)RpcUtils.getQualifiedMetricName(methodName)).time();){
            MetricsSystem.counter((String)RpcUtils.getQualifiedInProgressMetricName(methodName)).inc();
            logger.debug("Enter(stream): {}: {}", (Object)methodName, (Object)debugDesc);
            T result = callable.call();
            logger.debug("Exit(stream) (OK): {}: {}", (Object)methodName, (Object)debugDesc);
            if (sendResponse) {
                logger.debug("OnNext(stream): {}: {}", (Object)methodName, (Object)debugDesc);
                responseObserver.onNext(result);
            }
            if (completeResponse) {
                logger.debug("Completing(stream): {}: {}", (Object)methodName, (Object)debugDesc);
                responseObserver.onCompleted();
                logger.debug("Completed(stream): {}: {}", (Object)methodName, (Object)debugDesc);
            }
        }
        catch (Exception e) {
            logger.warn("Exit(stream) (Error): {}: {}, Error={}", new Object[]{methodName, String.format(description, args), e.toString()});
            MetricsSystem.counter((String)RpcUtils.getQualifiedFailureMetricName(methodName)).inc();
            callable.exceptionCaught(e);
        }
        finally {
            MetricsSystem.counter((String)RpcUtils.getQualifiedInProgressMetricName(methodName)).dec();
        }
    }

    protected static Object[] processObjects(Logger logger, Object ... args) {
        return SENSITIVE_CONFIG_MASKER == null ? args : SENSITIVE_CONFIG_MASKER.maskObjects(logger, args);
    }

    private static String getQualifiedMetricName(String methodName) {
        return RpcUtils.getQualifiedMetricNameInternal(methodName);
    }

    private static String getQualifiedFailureMetricName(String methodName) {
        return RpcUtils.getQualifiedMetricNameInternal(methodName, "Failures");
    }

    private static String getQualifiedInProgressMetricName(String methodName) {
        return RpcUtils.getQualifiedMetricNameInternal(methodName, "InProgress");
    }

    private static String getQualifiedMetricNameInternal(String ... components) {
        User user = AuthenticatedClientUser.getOrNull();
        if (user != null) {
            return Metric.getMetricNameWithUserTag((String)String.join((CharSequence)"", components), (String)user.getName());
        }
        return String.join((CharSequence)"", components);
    }

    public static interface StreamingRpcCallable<T> {
        public T call() throws Exception;

        public void exceptionCaught(Throwable var1);
    }

    public static interface RpcCallableThrowsIOException<T> {
        public T call() throws AlluxioException, IOException;
    }
}

