/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.ServerUserState;
import alluxio.util.SecurityUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.grpc.Status;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtils.class);

    public static <T> Response call(RestCallable<T> callable, AlluxioConfiguration alluxioConf, @Nullable Map<String, Object> headers) {
        try {
            if (SecurityUtils.isSecurityEnabled((AlluxioConfiguration)alluxioConf) && AuthenticatedClientUser.get((AlluxioConfiguration)alluxioConf) == null) {
                AuthenticatedClientUser.set((String)ServerUserState.global().getUser().getName());
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to set AuthenticatedClientUser in REST service handler: {}", (Object)e.toString());
            return RestUtils.createErrorResponse(e, alluxioConf);
        }
        try {
            return RestUtils.createResponse(callable.call(), alluxioConf, headers);
        }
        catch (Exception e) {
            LOG.warn("Unexpected error invoking rest endpoint: {}", (Object)e.toString());
            return RestUtils.createErrorResponse(e, alluxioConf);
        }
    }

    public static <T> Response call(RestCallable<T> callable, AlluxioConfiguration alluxioConf) {
        return RestUtils.call(callable, alluxioConf, null);
    }

    private static Response createResponse(Object object, AlluxioConfiguration alluxioConf, @Nullable Map<String, Object> headers) {
        if (object instanceof Void) {
            return Response.ok().build();
        }
        if (object instanceof String) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return Response.ok((Object)mapper.writeValueAsString(object)).build();
            }
            catch (JsonProcessingException e) {
                return RestUtils.createErrorResponse((Exception)((Object)e), alluxioConf);
            }
        }
        Response.ResponseBuilder rb = Response.ok((Object)object);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)rb).header(arg_0, arg_1));
        }
        if (alluxioConf.getBoolean(PropertyKey.WEB_CORS_ENABLED)) {
            return RestUtils.makeCORS(rb).build();
        }
        return rb.build();
    }

    private static Response createErrorResponse(Exception e, AlluxioConfiguration alluxioConf) {
        AlluxioStatusException se = AlluxioStatusException.fromThrowable((Throwable)e);
        ErrorResponse response = new ErrorResponse(se.getStatus().getCode(), se.getMessage());
        Response.ResponseBuilder rb = Response.serverError().entity((Object)response);
        if (alluxioConf.getBoolean(PropertyKey.WEB_CORS_ENABLED)) {
            return RestUtils.makeCORS(rb).build();
        }
        return rb.build();
    }

    public static Response.ResponseBuilder makeCORS(Response.ResponseBuilder responseBuilder, String returnMethod) {
        Response.ResponseBuilder rb = responseBuilder.header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET, POST, OPTIONS");
        if (!"".equals(returnMethod)) {
            rb.header("Access-Control-Allow-Headers", (Object)returnMethod);
        }
        return rb;
    }

    public static Response.ResponseBuilder makeCORS(Response.ResponseBuilder responseBuilder) {
        return RestUtils.makeCORS(responseBuilder, "");
    }

    private RestUtils() {
    }

    public static class ErrorResponse {
        private final Status.Code mStatusCode;
        private final String mMessage;

        public ErrorResponse(Status.Code statusCode, String message) {
            this.mStatusCode = statusCode;
            this.mMessage = message;
        }

        public Status.Code getStatusCode() {
            return this.mStatusCode;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }

    public static interface RestCallable<T> {
        public T call() throws Exception;
    }
}

