/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Server;
import alluxio.resource.LockResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Registry<T extends Server<U>, U> {
    private final Map<Class<? extends Server>, T> mRegistry = new HashMap<Class<? extends Server>, T>();
    private final Lock mLock = new ReentrantLock();

    public <W extends T> W get(Class<W> clazz) {
        return this.get(clazz, 60000);
    }

    public <W extends T> W get(Class<W> clazz, int timeoutMs) {
        try {
            CommonUtils.waitFor((String)("server " + clazz.getName() + " to be created"), () -> {
                try (LockResource r = new LockResource(this.mLock);){
                    Boolean bl = this.mRegistry.get(clazz) != null;
                    return bl;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(timeoutMs));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        Server server = (Server)this.mRegistry.get(clazz);
        if (!clazz.isInstance(server)) {
            throw new RuntimeException("Server is not an instance of " + clazz.getName());
        }
        return (W)((Server)clazz.cast(server));
    }

    public <W extends T> void add(Class<W> clazz, T server) {
        try (LockResource r = new LockResource(this.mLock);){
            this.mRegistry.put(clazz, server);
        }
    }

    public List<T> getServers() {
        ArrayList<T> servers = new ArrayList<T>(this.mRegistry.values());
        servers.sort(new DependencyComparator());
        return servers;
    }

    public void start(U options) throws IOException {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : this.getServers()) {
            try {
                server.start(options);
                servers.add(server);
            }
            catch (IOException e) {
                for (Server started : servers) {
                    started.stop();
                }
                throw e;
            }
        }
    }

    public void stop() throws IOException {
        for (Server server : Lists.reverse(this.getServers())) {
            server.stop();
        }
    }

    public void close() throws IOException {
        for (Server server : Lists.reverse(this.getServers())) {
            server.close();
        }
    }

    private Set<T> getTransitiveDeps(T server) {
        HashSet<Server> result = new HashSet<Server>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(server);
        while (!queue.isEmpty()) {
            Set deps = ((Server)queue.pop()).getDependencies();
            if (deps == null) continue;
            for (Class clazz : deps) {
                Server dep = (Server)this.mRegistry.get(clazz);
                if (dep == null) continue;
                if (dep.equals(server)) {
                    throw new RuntimeException("Dependency cycle encountered");
                }
                if (result.contains(dep)) continue;
                queue.add(dep);
                result.add(dep);
            }
        }
        return result;
    }

    private final class DependencyComparator
    implements Comparator<T> {
        DependencyComparator() {
        }

        @Override
        public int compare(T left, T right) {
            Set leftDeps = Registry.this.getTransitiveDeps(left);
            Set rightDeps = Registry.this.getTransitiveDeps(right);
            if (leftDeps.contains(right)) {
                return 1;
            }
            if (rightDeps.contains(left)) {
                return -1;
            }
            return left.getName().compareTo(right.getName());
        }
    }
}

