/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Process;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);

    public static void run(Process process) {
        try {
            LOG.info("Starting {}.", (Object)process);
            LOG.info("Alluxio version: {}-{}", (Object)"2.7.3", (Object)"bf10f79cbd99afc99f2d890ceeabb1ad939c3896");
            LOG.info("Java version: {}", (Object)System.getProperty("java.version"));
            process.start();
            LOG.info("Stopping {}.", (Object)process);
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.error("Uncaught exception while running {}, stopping it and exiting. Exception \"{}\", Root Cause \"{}\"", new Object[]{process, t, Throwables.getRootCause((Throwable)t), t});
            try {
                process.stop();
            }
            catch (Throwable t2) {
                LOG.error("Uncaught exception while stopping {}, simply exiting. Exception \"{}\", Root Cause \"{}\"", new Object[]{process, t2, Throwables.getRootCause((Throwable)t2), t2});
            }
            System.exit(-1);
        }
    }

    public static void fatalError(Logger logger, String format, Object ... args) {
        ProcessUtils.fatalError(logger, new Throwable(), format, args);
    }

    public static void fatalError(Logger logger, Throwable t, String format, Object ... args) {
        String message = String.format("Fatal error: " + format, args);
        if (t != null) {
            message = message + "\n" + Throwables.getStackTraceAsString((Throwable)t);
        }
        if (ServerConfiguration.getBoolean(PropertyKey.TEST_MODE)) {
            throw new RuntimeException(message);
        }
        logger.error(message);
        System.exit(-1);
    }

    public static void stopProcessOnShutdown(Process process) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                process.stop();
            }
            catch (Throwable t) {
                LOG.error("Failed to stop process", t);
            }
        }, "alluxio-process-shutdown-hook"));
    }

    private ProcessUtils() {
    }
}

