/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.StorageTierAssoc;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.collections.Pair;
import alluxio.conf.PropertyKey;
import alluxio.conf.ServerConfiguration;
import alluxio.worker.block.BlockStoreLocation;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractStorageTierAssoc
implements StorageTierAssoc {
    private final ImmutableBiMap<String, Integer> mAliasToOrdinal;

    static int interpretOrdinal(int ordinal, int numTiers) {
        if (ordinal >= 0) {
            return Math.min(ordinal, numTiers - 1);
        }
        return Math.max(numTiers + ordinal, 0);
    }

    protected AbstractStorageTierAssoc(PropertyKey levelsProperty, PropertyKey.Template template) {
        int levels = ServerConfiguration.getInt(levelsProperty);
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        for (int i = 0; i < levels; ++i) {
            String alias = ServerConfiguration.get(template.format(new Object[]{i}));
            builder.put((Object)alias, (Object)i);
        }
        this.mAliasToOrdinal = builder.build();
    }

    protected AbstractStorageTierAssoc(List<String> storageTierAliases) {
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        for (int ordinal = 0; ordinal < storageTierAliases.size(); ++ordinal) {
            builder.put((Object)storageTierAliases.get(ordinal), (Object)ordinal);
        }
        this.mAliasToOrdinal = builder.build();
    }

    public String getAlias(int ordinal) {
        return (String)this.mAliasToOrdinal.inverse().get((Object)AbstractStorageTierAssoc.interpretOrdinal(ordinal, this.mAliasToOrdinal.size()));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public int getOrdinal(String alias) {
        return (Integer)this.mAliasToOrdinal.get((Object)alias);
    }

    public int size() {
        return this.mAliasToOrdinal.size();
    }

    public List<String> getOrderedStorageAliases() {
        int size = this.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.getAlias(i));
        }
        return ret;
    }

    public List<Pair<BlockStoreLocation, BlockStoreLocation>> intersectionList() {
        ArrayList<Pair<BlockStoreLocation, BlockStoreLocation>> intersectionLocations = new ArrayList<Pair<BlockStoreLocation, BlockStoreLocation>>(this.size() - 1);
        int tierUp = 0;
        for (int tierDown = tierUp + 1; tierDown < this.size(); ++tierDown) {
            intersectionLocations.add((Pair<BlockStoreLocation, BlockStoreLocation>)new Pair((Object)BlockStoreLocation.anyDirInTier((String)this.getAlias(tierUp)), (Object)BlockStoreLocation.anyDirInTier((String)this.getAlias(tierDown))));
            ++tierUp;
        }
        return intersectionLocations;
    }
}

