/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.BlockInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileBlockInfo
implements Serializable {
    private static final long serialVersionUID = -3313640897617385301L;
    private BlockInfo mBlockInfo = new BlockInfo();
    private long mOffset;
    private ArrayList<String> mUfsLocations = new ArrayList();

    public BlockInfo getBlockInfo() {
        return this.mBlockInfo;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public List<String> getUfsLocations() {
        return this.mUfsLocations;
    }

    public FileBlockInfo setBlockInfo(BlockInfo blockInfo) {
        Preconditions.checkNotNull((Object)blockInfo, (Object)"blockInfo");
        this.mBlockInfo = blockInfo;
        return this;
    }

    public FileBlockInfo setOffset(long offset) {
        this.mOffset = offset;
        return this;
    }

    public FileBlockInfo setUfsLocations(List<String> ufsLocations) {
        Preconditions.checkNotNull(ufsLocations, (Object)"ufsLocations");
        this.mUfsLocations = new ArrayList<String>(ufsLocations);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileBlockInfo)) {
            return false;
        }
        FileBlockInfo that = (FileBlockInfo)o;
        return this.mBlockInfo.equals(that.mBlockInfo) && this.mOffset == that.mOffset && this.mUfsLocations.equals(that.mUfsLocations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mBlockInfo, this.mOffset, this.mUfsLocations});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockInfo", (Object)this.mBlockInfo).add("offset", this.mOffset).add("ufsLocations", this.mUfsLocations).toString();
    }
}

