/*
 * Decompiled with CFR 0.152.
 */
package alluxio.uri;

import alluxio.collections.Pair;
import alluxio.uri.Authority;
import alluxio.uri.StandardURI;
import alluxio.uri.URI;
import alluxio.util.URIUtils;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MultiPartSchemeURI
extends StandardURI {
    private static final long serialVersionUID = 8172074724822918502L;
    private final String mFullScheme;

    public MultiPartSchemeURI(String schemePrefix, String scheme, Authority authority, String path, String query) {
        super(scheme, authority, path, query);
        this.mFullScheme = this.getFullScheme(schemePrefix, this.mScheme);
    }

    protected MultiPartSchemeURI(URI baseUri, String fullScheme, String newPath) {
        super(baseUri, newPath);
        this.mFullScheme = fullScheme;
    }

    @Override
    public URI createNewPath(String newPath, boolean checkNormalization) {
        if (checkNormalization && URIUtils.needsNormalization(newPath)) {
            Pair<String, String> schemeComponents = URI.Factory.getSchemeComponents(this.mFullScheme);
            String schemePrefix = schemeComponents.getFirst();
            return new MultiPartSchemeURI(schemePrefix, this.mScheme, this.mAuthority, newPath, this.mQuery);
        }
        return new MultiPartSchemeURI(this, this.mFullScheme, newPath);
    }

    @Override
    public String getScheme() {
        return this.mFullScheme;
    }

    @Nullable
    private String getFullScheme(String schemePrefix, String uriScheme) {
        if (uriScheme == null) {
            return null;
        }
        if (schemePrefix == null || schemePrefix.isEmpty()) {
            return uriScheme;
        }
        return schemePrefix + ":" + uriScheme;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPartSchemeURI other = (MultiPartSchemeURI)o;
        return super.equals(o) && this.mFullScheme.equals(other.mFullScheme);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mFullScheme});
    }
}

