/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.security.User;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@NotThreadSafe
public final class AppLoginModule
implements LoginModule {
    private Subject mSubject;
    private User mUser;
    private CallbackHandler mCallbackHandler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.mSubject = subject;
        this.mCallbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("user name: ")};
        try {
            this.mCallbackHandler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
        String userName = ((NameCallback)callbacks[0]).getName();
        if (!userName.isEmpty()) {
            this.mUser = new User(userName);
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.logout();
        this.mUser = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.mSubject.getPrincipals(User.class).isEmpty()) {
            return true;
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().add(this.mUser);
            return true;
        }
        throw new LoginException("Cannot find a user");
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.mSubject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly.");
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().remove(this.mUser);
        }
        return true;
    }

    @NotThreadSafe
    public static final class AppCallbackHandler
    implements CallbackHandler {
        private final String mUserName;

        public AppCallbackHandler(String username) {
            this.mUserName = username;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof NameCallback)) {
                    Class<?> callbackClass = callback == null ? null : callback.getClass();
                    throw new UnsupportedCallbackException(callback, callbackClass + " is unsupported.");
                }
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.mUserName);
            }
        }
    }
}

