/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.conf.PropertyKey;
import alluxio.util.ConfigurationUtils;
import io.netty.util.ResourceLeakDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlluxioResourceLeakDetector<T>
extends ResourceLeakDetector<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlluxioResourceLeakDetector.class);
    private static final String DOC_URL = "https://docs.alluxio.io/os/user/stable/en/operation/Troubleshooting.html#resource-leak-detection";
    private final boolean mExitOnLeak;

    public AlluxioResourceLeakDetector(Class<?> resourceType, int samplingInterval, boolean exitOnLeak) {
        super(resourceType, samplingInterval);
        this.mExitOnLeak = exitOnLeak;
    }

    protected void reportTracedLeak(String resourceType, String records) {
        LOGGER.error("LEAK: {}.close() was not called before resource is garbage-collected. See {} for more information about this message.{}", new Object[]{resourceType, DOC_URL, records});
        if (this.mExitOnLeak) {
            LOGGER.error("Leak detected when {} set to true. Shutting down the JVM", (Object)"alluxio.leak.detector.exit.on.leak");
            System.exit(1);
        }
    }

    protected void reportUntracedLeak(String resourceType) {
        LOGGER.error("LEAK: {}.close() was not called before resource is garbage-collected. See {} for more information about this message.", (Object)resourceType, (Object)DOC_URL);
        if (this.mExitOnLeak) {
            LOGGER.error("Leak detected when {} set to true. Shutting down the JVM", (Object)"alluxio.leak.detector.exit.on.leak");
            System.exit(1);
        }
    }

    static {
        ResourceLeakDetector.Level lev = (ResourceLeakDetector.Level)ConfigurationUtils.getPropertyValue(PropertyKey.LEAK_DETECTOR_LEVEL);
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)lev);
    }
}

